/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.FixedSourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.split.EmptySplit;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SourcePartitionedScheduler
implements StageScheduler {
    private final SqlStageExecution stage;
    private final SplitSource splitSource;
    private final SplitPlacementPolicy splitPlacementPolicy;
    private final int splitBatchSize;
    private final PlanNodeId partitionedNode;
    private final boolean autoDropCompletedLifespans;
    private final Map<Lifespan, ScheduleGroup> scheduleGroups = new HashMap<Lifespan, ScheduleGroup>();
    private State state = State.INITIALIZED;
    private SettableFuture<?> whenFinishedOrNewLifespanAdded = SettableFuture.create();

    private SourcePartitionedScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, boolean autoDropCompletedLifespans) {
        this.stage = Objects.requireNonNull(stage, "stage is null");
        this.partitionedNode = Objects.requireNonNull(partitionedNode, "partitionedNode is null");
        this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
        this.splitPlacementPolicy = Objects.requireNonNull(splitPlacementPolicy, "splitPlacementPolicy is null");
        Preconditions.checkArgument((splitBatchSize > 0 ? 1 : 0) != 0, (Object)"splitBatchSize must be at least one");
        this.splitBatchSize = splitBatchSize;
        this.autoDropCompletedLifespans = autoDropCompletedLifespans;
    }

    public static SourcePartitionedScheduler simpleSourcePartitionedScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize) {
        SourcePartitionedScheduler result = new SourcePartitionedScheduler(stage, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, true);
        result.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
        return result;
    }

    public static SourcePartitionedScheduler managedSourcePartitionedScheduler(SqlStageExecution stage, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize) {
        return new SourcePartitionedScheduler(stage, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, false);
    }

    public synchronized void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
        Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SPLITS_ADDED ? 1 : 0) != 0);
        this.scheduleGroups.put(lifespan, new ScheduleGroup(partitionHandle));
        this.whenFinishedOrNewLifespanAdded.set(null);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public synchronized ScheduleResult schedule() {
        int overallSplitAssignmentCount = 0;
        ImmutableSet.Builder overallNewTasks = ImmutableSet.builder();
        ArrayList<Object> overallBlockedFutures = new ArrayList<Object>();
        boolean anyBlockedOnPlacements = false;
        boolean anyBlockedOnNextSplitBatch = false;
        boolean anyNotBlocked = false;
        for (Map.Entry<Lifespan, ScheduleGroup> entry : this.scheduleGroups.entrySet()) {
            Lifespan lifespan = entry.getKey();
            ScheduleGroup scheduleGroup = entry.getValue();
            Set<Split> pendingSplits = scheduleGroup.pendingSplits;
            if (scheduleGroup.state != ScheduleGroupState.DISCOVERING_SPLITS) {
                Verify.verify((scheduleGroup.nextSplitBatchFuture == null ? 1 : 0) != 0);
            } else if (pendingSplits.isEmpty()) {
                if (scheduleGroup.nextSplitBatchFuture == null) {
                    scheduleGroup.nextSplitBatchFuture = this.splitSource.getNextBatch(scheduleGroup.partitionHandle, lifespan, this.splitBatchSize - pendingSplits.size());
                    long start = System.nanoTime();
                    MoreFutures.addSuccessCallback(scheduleGroup.nextSplitBatchFuture, () -> this.stage.recordGetSplitTime(start));
                }
                if (scheduleGroup.nextSplitBatchFuture.isDone()) {
                    SplitSource.SplitBatch nextSplits = (SplitSource.SplitBatch)MoreFutures.getFutureValue(scheduleGroup.nextSplitBatchFuture);
                    scheduleGroup.nextSplitBatchFuture = null;
                    pendingSplits.addAll(nextSplits.getSplits());
                    if (nextSplits.isLastBatch() && scheduleGroup.state == ScheduleGroupState.DISCOVERING_SPLITS) {
                        scheduleGroup.state = ScheduleGroupState.NO_MORE_SPLITS;
                    }
                } else {
                    overallBlockedFutures.add(scheduleGroup.nextSplitBatchFuture);
                    anyBlockedOnNextSplitBatch = true;
                    continue;
                }
            }
            Multimap<Node, Split> splitAssignment = ImmutableMultimap.of();
            if (!pendingSplits.isEmpty()) {
                if (!scheduleGroup.placementFuture.isDone()) continue;
                if (this.state == State.INITIALIZED) {
                    this.state = State.SPLITS_ADDED;
                }
                SplitPlacementResult splitPlacementResult = this.splitPlacementPolicy.computeAssignments(pendingSplits);
                splitAssignment = splitPlacementResult.getAssignments();
                splitAssignment.values().forEach(pendingSplits::remove);
                overallSplitAssignmentCount += splitAssignment.size();
                if (!pendingSplits.isEmpty()) {
                    scheduleGroup.placementFuture = splitPlacementResult.getBlocked();
                    overallBlockedFutures.add(scheduleGroup.placementFuture);
                    anyBlockedOnPlacements = true;
                }
            }
            ImmutableMultimap noMoreSplitsNotification = ImmutableMultimap.of();
            if (pendingSplits.isEmpty() && scheduleGroup.state == ScheduleGroupState.NO_MORE_SPLITS) {
                scheduleGroup.state = ScheduleGroupState.DONE;
                if (!lifespan.isTaskWide()) {
                    Node node = ((FixedSourcePartitionedScheduler.FixedSplitPlacementPolicy)this.splitPlacementPolicy).getNodeForBucket(lifespan.getId());
                    noMoreSplitsNotification = ImmutableMultimap.of((Object)node, (Object)lifespan);
                }
            }
            overallNewTasks.addAll(this.assignSplits(splitAssignment, (Multimap<Node, Lifespan>)noMoreSplitsNotification));
            if (scheduleGroup.nextSplitBatchFuture != null || !scheduleGroup.pendingSplits.isEmpty() || scheduleGroup.state == ScheduleGroupState.DONE) continue;
            anyNotBlocked = true;
        }
        if (this.autoDropCompletedLifespans) {
            this.drainCompletedLifespans();
        }
        if (this.state == State.NO_MORE_SPLITS || this.state == State.FINISHED || this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            switch (this.state) {
                case INITIALIZED: {
                    this.state = State.SPLITS_ADDED;
                    ScheduleResult emptySplitScheduleResult = this.scheduleEmptySplit();
                    overallNewTasks.addAll(emptySplitScheduleResult.getNewTasks());
                    ++overallSplitAssignmentCount;
                }
                case SPLITS_ADDED: {
                    this.state = State.NO_MORE_SPLITS;
                    this.splitSource.close();
                }
                case NO_MORE_SPLITS: {
                    this.state = State.FINISHED;
                    this.whenFinishedOrNewLifespanAdded.set(null);
                }
                case FINISHED: {
                    return new ScheduleResult(true, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
                }
            }
            throw new IllegalStateException("Unknown state");
        }
        if (anyNotBlocked) {
            return new ScheduleResult(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
        }
        overallNewTasks.addAll(this.finalizeTaskCreationIfNecessary());
        ScheduleResult.BlockedReason blockedReason = anyBlockedOnNextSplitBatch ? (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE : ScheduleResult.BlockedReason.WAITING_FOR_SOURCE) : (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL : ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP);
        overallBlockedFutures.add(this.whenFinishedOrNewLifespanAdded);
        return new ScheduleResult(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), Futures.nonCancellationPropagating((ListenableFuture)MoreFutures.whenAnyComplete(overallBlockedFutures)), blockedReason, overallSplitAssignmentCount);
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    public synchronized List<Lifespan> drainCompletedLifespans() {
        if (this.scheduleGroups.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        Iterator<Map.Entry<Lifespan, ScheduleGroup>> entryIterator = this.scheduleGroups.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Lifespan, ScheduleGroup> entry = entryIterator.next();
            if (entry.getValue().state != ScheduleGroupState.DONE) continue;
            result.add((Object)entry.getKey());
            entryIterator.remove();
        }
        if (this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            this.whenFinishedOrNewLifespanAdded.set(null);
            this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
        }
        return result.build();
    }

    private ScheduleResult scheduleEmptySplit() {
        this.state = State.SPLITS_ADDED;
        List<Node> nodes = this.splitPlacementPolicy.allNodes();
        Failures.checkCondition(!nodes.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query", new Object[0]);
        Node node = nodes.iterator().next();
        Split emptySplit = new Split(this.splitSource.getConnectorId(), this.splitSource.getTransactionHandle(), new EmptySplit(this.splitSource.getConnectorId()));
        Set<RemoteTask> emptyTask = this.assignSplits((Multimap<Node, Split>)ImmutableMultimap.of((Object)node, (Object)emptySplit), (Multimap<Node, Lifespan>)ImmutableMultimap.of());
        return new ScheduleResult(false, emptyTask, 1);
    }

    private Set<RemoteTask> assignSplits(Multimap<Node, Split> splitAssignment, Multimap<Node, Lifespan> noMoreSplitsNotification) {
        ImmutableSet.Builder newTasks = ImmutableSet.builder();
        ImmutableSet nodes = ImmutableSet.builder().addAll((Iterable)splitAssignment.keySet()).addAll((Iterable)noMoreSplitsNotification.keySet()).build();
        for (Node node : nodes) {
            ImmutableMultimap splits = ImmutableMultimap.builder().putAll((Object)this.partitionedNode, (Iterable)splitAssignment.get((Object)node)).build();
            ImmutableMultimap.Builder noMoreSplits = ImmutableMultimap.builder();
            if (noMoreSplitsNotification.containsKey((Object)node)) {
                noMoreSplits.putAll((Object)this.partitionedNode, (Iterable)noMoreSplitsNotification.get((Object)node));
            }
            newTasks.addAll(this.stage.scheduleSplits(node, (Multimap<PlanNodeId, Split>)splits, (Multimap<PlanNodeId, Lifespan>)noMoreSplits.build()));
        }
        return newTasks.build();
    }

    private Set<RemoteTask> finalizeTaskCreationIfNecessary() {
        if (this.stage.getFragment().isLeaf()) {
            return ImmutableSet.of();
        }
        this.splitPlacementPolicy.lockDownNodes();
        Set<Node> scheduledNodes = this.stage.getScheduledNodes();
        Set newTasks = (Set)this.splitPlacementPolicy.allNodes().stream().filter(node -> !scheduledNodes.contains(node)).flatMap(node -> this.stage.scheduleSplits((Node)node, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of()).stream()).collect(ImmutableSet.toImmutableSet());
        this.stage.transitionToSchedulingSplits();
        return newTasks;
    }

    private static enum ScheduleGroupState {
        DISCOVERING_SPLITS,
        NO_MORE_SPLITS,
        DONE;

    }

    private static class ScheduleGroup {
        public final ConnectorPartitionHandle partitionHandle;
        public ListenableFuture<SplitSource.SplitBatch> nextSplitBatchFuture;
        public ListenableFuture<?> placementFuture = Futures.immediateFuture(null);
        public final Set<Split> pendingSplits = new HashSet<Split>();
        public ScheduleGroupState state = ScheduleGroupState.DISCOVERING_SPLITS;

        public ScheduleGroup(ConnectorPartitionHandle partitionHandle) {
            this.partitionHandle = Objects.requireNonNull(partitionHandle, "partitionHandle is null");
        }
    }

    private static enum State {
        INITIALIZED,
        SPLITS_ADDED,
        NO_MORE_SPLITS,
        FINISHED;

    }
}

