/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TaskStatus {
    public static final long STARTING_VERSION = 1L;
    private static final long MIN_VERSION = 0L;
    private static final long MAX_VERSION = Long.MAX_VALUE;
    private final TaskId taskId;
    private final String taskInstanceId;
    private final long version;
    private final TaskState state;
    private final URI self;
    private final String nodeId;
    private final Set<Lifespan> completedDriverGroups;
    private final int queuedPartitionedDrivers;
    private final int runningPartitionedDrivers;
    private final boolean outputBufferOverutilized;
    private final DataSize physicalWrittenDataSize;
    private final DataSize memoryReservation;
    private final DataSize systemMemoryReservation;
    private final long fullGcCount;
    private final Duration fullGcTime;
    private final List<ExecutionFailureInfo> failures;

    @JsonCreator
    public TaskStatus(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="taskInstanceId") String taskInstanceId, @JsonProperty(value="version") long version, @JsonProperty(value="state") TaskState state, @JsonProperty(value="self") URI self, @JsonProperty(value="nodeId") String nodeId, @JsonProperty(value="completedDriverGroups") Set<Lifespan> completedDriverGroups, @JsonProperty(value="failures") List<ExecutionFailureInfo> failures, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="outputBufferOverutilized") boolean outputBufferOverutilized, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="fullGcCount") long fullGcCount, @JsonProperty(value="fullGcTime") Duration fullGcTime) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        Preconditions.checkState((version >= 0L ? 1 : 0) != 0, (Object)"version must be >= MIN_VERSION");
        this.version = version;
        this.state = Objects.requireNonNull(state, "state is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        this.completedDriverGroups = Objects.requireNonNull(completedDriverGroups, "completedDriverGroups is null");
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers must be positive");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers must be positive");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        this.outputBufferOverutilized = outputBufferOverutilized;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.memoryReservation = Objects.requireNonNull(memoryReservation, "memoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.failures = ImmutableList.copyOf((Collection)Objects.requireNonNull(failures, "failures is null"));
        Preconditions.checkArgument((fullGcCount >= 0L ? 1 : 0) != 0, (Object)"fullGcCount is negative");
        this.fullGcCount = fullGcCount;
        this.fullGcTime = Objects.requireNonNull(fullGcTime, "fullGcTime is null");
    }

    @JsonProperty
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonProperty
    public Set<Lifespan> getCompletedDriverGroups() {
        return this.completedDriverGroups;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getFailures() {
        return this.failures;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public boolean isOutputBufferOverutilized() {
        return this.outputBufferOverutilized;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public long getFullGcCount() {
        return this.fullGcCount;
    }

    @JsonProperty
    public Duration getFullGcTime() {
        return this.fullGcTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("state", (Object)this.state).toString();
    }

    public static TaskStatus initialTaskStatus(TaskId taskId, URI location, String nodeId) {
        return new TaskStatus(taskId, "", 0L, TaskState.PLANNED, location, nodeId, (Set<Lifespan>)ImmutableSet.of(), (List<ExecutionFailureInfo>)ImmutableList.of(), 0, 0, false, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), 0L, new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    public static TaskStatus failWith(TaskStatus taskStatus, TaskState state, List<ExecutionFailureInfo> exceptions) {
        return new TaskStatus(taskStatus.getTaskId(), taskStatus.getTaskInstanceId(), Long.MAX_VALUE, state, taskStatus.getSelf(), taskStatus.getNodeId(), taskStatus.getCompletedDriverGroups(), exceptions, taskStatus.getQueuedPartitionedDrivers(), taskStatus.getRunningPartitionedDrivers(), taskStatus.isOutputBufferOverutilized(), taskStatus.getPhysicalWrittenDataSize(), taskStatus.getMemoryReservation(), taskStatus.getSystemMemoryReservation(), taskStatus.getFullGcCount(), taskStatus.getFullGcTime());
    }
}

