/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class QueryStats {
    private final DateTime createTime;
    private final DateTime executionStartTime;
    private final DateTime lastHeartbeat;
    private final DateTime endTime;
    private final Duration elapsedTime;
    private final Duration queuedTime;
    private final Duration resourceWaitingTime;
    private final Duration analysisTime;
    private final Duration distributedPlanningTime;
    private final Duration totalPlanningTime;
    private final Duration finishingTime;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize peakTaskTotalMemory;
    private final boolean scheduled;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final List<StageGcStatistics> stageGcStatistics;
    private final List<OperatorStats> operatorSummaries;

    @VisibleForTesting
    public QueryStats() {
        this.createTime = null;
        this.executionStartTime = null;
        this.lastHeartbeat = null;
        this.endTime = null;
        this.elapsedTime = null;
        this.queuedTime = null;
        this.resourceWaitingTime = null;
        this.analysisTime = null;
        this.distributedPlanningTime = null;
        this.totalPlanningTime = null;
        this.finishingTime = null;
        this.totalTasks = 0;
        this.runningTasks = 0;
        this.blockedDrivers = 0;
        this.completedTasks = 0;
        this.totalDrivers = 0;
        this.queuedDrivers = 0;
        this.runningDrivers = 0;
        this.completedDrivers = 0;
        this.cumulativeUserMemory = 0.0;
        this.userMemoryReservation = null;
        this.totalMemoryReservation = null;
        this.peakUserMemoryReservation = null;
        this.peakTotalMemoryReservation = null;
        this.peakTaskTotalMemory = null;
        this.scheduled = false;
        this.totalScheduledTime = null;
        this.totalCpuTime = null;
        this.totalUserTime = null;
        this.totalBlockedTime = null;
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.rawInputDataSize = null;
        this.rawInputPositions = 0L;
        this.processedInputDataSize = null;
        this.processedInputPositions = 0L;
        this.outputDataSize = null;
        this.outputPositions = 0L;
        this.physicalWrittenDataSize = null;
        this.stageGcStatistics = null;
        this.operatorSummaries = null;
    }

    @JsonCreator
    public QueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="executionStartTime") DateTime executionStartTime, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="resourceWaitingTime") Duration resourceWaitingTime, @JsonProperty(value="analysisTime") Duration analysisTime, @JsonProperty(value="distributedPlanningTime") Duration distributedPlanningTime, @JsonProperty(value="totalPlanningTime") Duration totalPlanningTime, @JsonProperty(value="finishingTime") Duration finishingTime, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="peakTaskTotalMemory") DataSize peakTaskTotalMemory, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="stageGcStatistics") List<StageGcStatistics> stageGcStatistics, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.executionStartTime = executionStartTime;
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.endTime = endTime;
        this.elapsedTime = elapsedTime;
        this.queuedTime = queuedTime;
        this.resourceWaitingTime = resourceWaitingTime;
        this.analysisTime = analysisTime;
        this.distributedPlanningTime = distributedPlanningTime;
        this.totalPlanningTime = totalPlanningTime;
        this.finishingTime = finishingTime;
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.peakTaskTotalMemory = Objects.requireNonNull(peakTaskTotalMemory, "peakTaskTotalMemory is null");
        this.scheduled = scheduled;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalUserTime = Objects.requireNonNull(totalUserTime, "totalUserTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.stageGcStatistics = ImmutableList.copyOf((Collection)Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null"));
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public DateTime getExecutionStartTime() {
        return this.executionStartTime;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getResourceWaitingTime() {
        return this.resourceWaitingTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        if (this.queuedTime == null) {
            return this.elapsedTime;
        }
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getExecutionTime() {
        if (this.queuedTime == null) {
            return new Duration(0.0, TimeUnit.NANOSECONDS);
        }
        long executionNanos = (long)this.elapsedTime.getValue(TimeUnit.NANOSECONDS) - (long)this.queuedTime.getValue(TimeUnit.NANOSECONDS);
        return Duration.succinctNanos((long)Math.max(0L, executionNanos));
    }

    @JsonProperty
    public Duration getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Duration getDistributedPlanningTime() {
        return this.distributedPlanningTime;
    }

    @JsonProperty
    public Duration getTotalPlanningTime() {
        return this.totalPlanningTime;
    }

    @JsonProperty
    public Duration getFinishingTime() {
        return this.finishingTime;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public long getWrittenPositions() {
        return this.operatorSummaries.stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(stats -> stats.getInputPositions()).sum();
    }

    @JsonProperty
    public DataSize getLogicalWrittenDataSize() {
        return DataSize.succinctBytes((long)this.operatorSummaries.stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(stats -> stats.getInputDataSize().toBytes()).sum());
    }

    @JsonProperty
    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        if (!this.scheduled || this.totalDrivers == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
    }
}

