/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.planner.Plan;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

public class MemoryAwareQueryExecution
implements QueryExecution {
    private final ClusterMemoryManager memoryManager;
    private final SqlQueryExecution delegate;
    private final long peakMemoryEstimate;
    @GuardedBy(value="this")
    private boolean startedWaiting;

    public MemoryAwareQueryExecution(ClusterMemoryManager memoryManager, SqlQueryExecution delegate) {
        this.memoryManager = memoryManager;
        this.delegate = delegate;
        this.peakMemoryEstimate = delegate.getSession().getResourceEstimates().getPeakMemory().map(DataSize::toBytes).orElse(0L);
    }

    @Override
    public QueryId getQueryId() {
        return this.delegate.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.delegate.getQueryInfo();
    }

    @Override
    public QueryState getState() {
        return this.delegate.getState();
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.delegate.getStateChange(currentState);
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.delegate.addOutputInfoListener(listener);
    }

    @Override
    public Optional<ResourceGroupId> getResourceGroup() {
        return this.delegate.getResourceGroup();
    }

    @Override
    public void setResourceGroup(ResourceGroupId resourceGroupId) {
        this.delegate.setResourceGroup(resourceGroupId);
    }

    @Override
    public Plan getQueryPlan() {
        return this.delegate.getQueryPlan();
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.delegate.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.delegate.setMemoryPool(poolId);
    }

    @Override
    public long getUserMemoryReservation() {
        return this.delegate.getUserMemoryReservation();
    }

    @Override
    public long getTotalMemoryReservation() {
        return this.delegate.getTotalMemoryReservation();
    }

    @Override
    public Duration getTotalCpuTime() {
        return this.delegate.getTotalCpuTime();
    }

    @Override
    public Session getSession() {
        return this.delegate.getSession();
    }

    @Override
    public synchronized void start() {
        Throwable throwable;
        SetThreadName ignored;
        block18: {
            block19: {
                block20: {
                    ignored = new SetThreadName("Query-%s", new Object[]{this.delegate.getQueryId()});
                    throwable = null;
                    if (!this.memoryManager.preAllocateQueryMemory(this.delegate.getQueryId(), this.peakMemoryEstimate)) break block18;
                    this.delegate.addStateChangeListener(state -> {
                        if (state.isDone()) {
                            this.memoryManager.removePreAllocation(this.delegate.getQueryId());
                        }
                    });
                    this.delegate.start();
                    if (ignored == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                if (!this.startedWaiting) {
                    this.startedWaiting = true;
                    this.delegate.startWaitingForResources();
                    this.memoryManager.addChangeListener(LocalMemoryManager.GENERAL_POOL, none -> this.start());
                    this.memoryManager.addChangeListener(LocalMemoryManager.RESERVED_POOL, none -> this.start());
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        this.delegate.fail(cause);
    }

    @Override
    public void cancelQuery() {
        this.delegate.cancelQuery();
    }

    @Override
    public void cancelStage(StageId stageId) {
        this.delegate.cancelStage(stageId);
    }

    @Override
    public void recordHeartbeat() {
        this.delegate.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.delegate.pruneInfo();
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.delegate.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.delegate.addFinalQueryInfoListener(stateChangeListener);
    }
}

