/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class SimpleStatsRule<T extends PlanNode>
implements ComposableStatsCalculator.Rule<T> {
    private final StatsNormalizer normalizer;

    protected SimpleStatsRule(StatsNormalizer normalizer) {
        this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
    }

    @Override
    public final Optional<PlanNodeStatsEstimate> calculate(T node, StatsProvider sourceStats, Lookup lookup, Session session, Map<Symbol, Type> types) {
        return this.doCalculate(node, sourceStats, lookup, session, types).map(estimate -> this.normalizer.normalize((PlanNodeStatsEstimate)estimate, (Collection<Symbol>)node.getOutputSymbols(), types));
    }

    protected abstract Optional<PlanNodeStatsEstimate> doCalculate(T var1, StatsProvider var2, Lookup var3, Session var4, Map<Symbol, Type> var5);
}

