/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.inject.BindingAnnotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class SelectingStatsCalculator
implements StatsCalculator {
    private final StatsCalculator oldStatsCalculator;
    private final StatsCalculator newStatsCalculator;

    @Inject
    public SelectingStatsCalculator(@Old StatsCalculator oldStatsCalculator, @New StatsCalculator newStatsCalculator) {
        this.oldStatsCalculator = Objects.requireNonNull(oldStatsCalculator, "oldStatsCalculator can not be null");
        this.newStatsCalculator = Objects.requireNonNull(newStatsCalculator, "newStatsCalculator can not be null");
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, Map<Symbol, Type> types) {
        if (SystemSessionProperties.isEnableNewStatsCalculator(session)) {
            return this.newStatsCalculator.calculateStats(node, sourceStats, lookup, session, types);
        }
        return this.oldStatsCalculator.calculateStats(node, sourceStats, lookup, session, types);
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface New {
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Old {
    }
}

