/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.transaction.TransactionId;

public final class SystemConnectorSessionUtil {
    private static final SystemSessionProperties SYSTEM_SESSION_PROPERTIES = new SystemSessionProperties();

    private SystemConnectorSessionUtil() {
    }

    public static Session toSession(ConnectorTransactionHandle transactionHandle, ConnectorSession session) {
        TransactionId transactionId = ((GlobalSystemTransactionHandle)transactionHandle).getTransactionId();
        return Session.builder(new SessionPropertyManager(SYSTEM_SESSION_PROPERTIES)).setQueryId(new QueryId(session.getQueryId())).setTransactionId(transactionId).setCatalog("catalog").setSchema("schema").setIdentity(session.getIdentity()).setTimeZoneKey(session.getTimeZoneKey()).setLocale(session.getLocale()).setStartTime(session.getStartTime()).build();
    }
}

