/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class TestingNodeManager
implements NodeManager {
    private static final String TEST_ENVIRONMENT = "testenv";
    private final String environment;
    private final Node localNode;
    private final Set<Node> nodes = new CopyOnWriteArraySet<Node>();

    public TestingNodeManager() {
        this(TEST_ENVIRONMENT);
    }

    public TestingNodeManager(String environment) {
        this(environment, new PrestoNode("local", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true), (Collection<Node>)ImmutableSet.of());
    }

    public TestingNodeManager(Node localNode) {
        this(localNode, (Collection<Node>)ImmutableSet.of());
    }

    public TestingNodeManager(List<Node> allNodes) {
        this(allNodes.iterator().next(), allNodes);
    }

    public TestingNodeManager(Node localNode, Collection<Node> otherNodes) {
        this(TEST_ENVIRONMENT, localNode, otherNodes);
    }

    public TestingNodeManager(String environment, Node localNode, Collection<Node> otherNodes) {
        this.environment = environment;
        this.localNode = Objects.requireNonNull(localNode, "localNode is null");
        this.nodes.add(localNode);
        this.nodes.addAll(otherNodes);
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public Set<Node> getAllNodes() {
        return this.nodes;
    }

    public Set<Node> getWorkerNodes() {
        return this.nodes;
    }

    public Node getCurrentNode() {
        return this.localNode;
    }

    public String getEnvironment() {
        return this.environment;
    }
}

