/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import com.facebook.presto.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.planner.sanity.ValidateDependenciesChecker;
import com.facebook.presto.sql.planner.sanity.VerifyNoFilteredAggregations;
import com.facebook.presto.sql.planner.sanity.VerifyOnlyOneOutputNode;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;

public final class PlanSanityChecker {
    private static final Multimap<Stage, Checker> CHECKERS = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations()}).build();

    private PlanSanityChecker() {
    }

    public static void validateFinalPlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        CHECKERS.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types));
    }

    public static void validateIntermediatePlan(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        CHECKERS.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types));
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, SqlParser var4, Map<Symbol, Type> var5);
    }
}

