/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.util.MoreLists;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Aggregation> aggregations;
    private final List<List<Symbol>> groupingSets;
    private final Step step;
    private final Optional<Symbol> hashSymbol;
    private final Optional<Symbol> groupIdSymbol;
    private final List<Symbol> outputs;

    @JsonCreator
    public AggregationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="aggregations") Map<Symbol, Aggregation> aggregations, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="step") Step step, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="groupIdSymbol") Optional<Symbol> groupIdSymbol) {
        super(id);
        this.source = source;
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets list cannot be empty");
        this.groupingSets = MoreLists.listOfListsCopy(groupingSets);
        boolean hasOrderBy = aggregations.values().stream().map(Aggregation::getCall).map(FunctionCall::getOrderBy).noneMatch(Optional::isPresent);
        Preconditions.checkArgument((hasOrderBy || step == Step.SINGLE ? 1 : 0) != 0, (Object)"ORDER BY does not support distributed aggregation");
        this.step = step;
        this.hashSymbol = hashSymbol;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(this.getGroupingKeys());
        hashSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputs).add(arg_0));
        outputs.addAll(aggregations.keySet());
        this.outputs = outputs.build();
    }

    public List<Symbol> getGroupingKeys() {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>(this.groupingSets.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        this.groupIdSymbol.ifPresent(symbols::add);
        return symbols;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step.equals((Object)Step.SINGLE));
    }

    public boolean hasEmptyGroupingSet() {
        return this.groupingSets.stream().anyMatch(List::isEmpty);
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.stream().anyMatch(symbols -> !symbols.isEmpty());
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Map<Symbol, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="groupingSets")
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty(value="groupIdSymbol")
    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    public boolean hasOrderings() {
        return this.aggregations.values().stream().map(Aggregation::getCall).map(FunctionCall::getOrderBy).anyMatch(Optional::isPresent);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new AggregationNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.aggregations, this.groupingSets, this.step, this.hashSymbol, this.groupIdSymbol);
    }

    public boolean isDecomposable(FunctionRegistry functionRegistry) {
        return this.getAggregations().entrySet().stream().map(entry -> functionRegistry.getAggregateFunctionImplementation(((Aggregation)entry.getValue()).getSignature())).allMatch(InternalAggregationFunction::isDecomposable) && this.getAggregations().entrySet().stream().allMatch(entry -> !((Aggregation)entry.getValue()).getCall().getOrderBy().isPresent());
    }

    public static class Aggregation {
        private final FunctionCall call;
        private final Signature signature;
        private final Optional<Symbol> mask;

        @JsonCreator
        public Aggregation(@JsonProperty(value="call") FunctionCall call, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="mask") Optional<Symbol> mask) {
            this.call = call;
            this.signature = signature;
            this.mask = mask;
        }

        @JsonProperty
        public FunctionCall getCall() {
            return this.call;
        }

        @JsonProperty
        public Signature getSignature() {
            return this.signature;
        }

        @JsonProperty
        public Optional<Symbol> getMask() {
            return this.mask;
        }
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }
    }
}

