/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataQueryOptimizer
implements PlanOptimizer {
    private static final Set<String> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)"max", (Object)"min", (Object)"approx_distinct");
    private final Metadata metadata;

    public MetadataQueryOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!SystemSessionProperties.isOptimizeMetadataQueries(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Optimizer(session, this.metadata, idAllocator), plan, null);
    }

    private static class Replacer
    extends SimplePlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;

        private Optimizer(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                if (ALLOWED_FUNCTIONS.contains(aggregation.getCall().getName().toString()) || aggregation.getCall().isDistinct()) continue;
                return context.defaultRewrite(node);
            }
            Optional<TableScanNode> result = Optimizer.findTableScan(node.getSource());
            if (!result.isPresent()) {
                return context.defaultRewrite(node);
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List<Symbol> inputs = tableScan.getOutputSymbols();
            for (Symbol symbol : inputs) {
                ColumnHandle column = tableScan.getAssignments().get(symbol);
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(this.session, tableScan.getTable(), column);
                typesBuilder.put((Object)symbol, (Object)columnMetadata.getType());
                columnBuilder.put((Object)symbol, (Object)column);
            }
            ImmutableMap columns = columnBuilder.build();
            ImmutableMap types = typesBuilder.build();
            TableLayout layout = null;
            if (!tableScan.getLayout().isPresent()) {
                List<TableLayoutResult> layouts = this.metadata.getLayouts(this.session, tableScan.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
                if (layouts.size() == 1) {
                    layout = ((TableLayoutResult)Iterables.getOnlyElement(layouts)).getLayout();
                }
            } else {
                layout = this.metadata.getLayout(this.session, tableScan.getLayout().get());
            }
            if (layout == null || !layout.getDiscretePredicates().isPresent()) {
                return context.defaultRewrite(node);
            }
            DiscretePredicates predicates = layout.getDiscretePredicates().get();
            if (!predicates.getColumns().containsAll(columns.values())) {
                return context.defaultRewrite(node);
            }
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (TupleDomain domain : predicates.getPredicates()) {
                if (domain.isNone()) continue;
                Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (Symbol input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    Type type = (Type)types.get(input);
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite(node);
                    }
                    rowBuilder.add((Object)LiteralInterpreter.toExpression(value.getValue(), type));
                }
                rowsBuilder.add((Object)rowBuilder.build());
            }
            ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), inputs, (List<List<Expression>>)rowsBuilder.build());
            return SimplePlanRewriter.rewriteWith(new Replacer(valuesNode), node);
        }

        private static Optional<TableScanNode> findTableScan(PlanNode source) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all(project.getAssignments().getExpressions(), DeterminismEvaluator::isDeterministic)) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                return Optional.of((TableScanNode)source);
            }
            return Optional.empty();
        }
    }
}

