/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Deprecated
public class DetermineJoinDistributionType
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(session), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Session session;

        public Rewriter(Session session) {
            this.session = session;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode leftRewritten = context.rewrite(node.getLeft(), context.get());
            PlanNode rightRewritten = context.rewrite(node.getRight(), context.get());
            JoinNode.DistributionType targetJoinDistributionType = this.getTargetJoinDistributionType(node);
            return new JoinNode(node.getId(), node.getType(), leftRewritten, rightRewritten, node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), Optional.of(targetJoinDistributionType));
        }

        private JoinNode.DistributionType getTargetJoinDistributionType(JoinNode node) {
            JoinNode.Type type = node.getType();
            if (type == JoinNode.Type.RIGHT || type == JoinNode.Type.FULL || SystemSessionProperties.isDistributedJoinEnabled(this.session) && !Rewriter.mustBroadcastJoin(node)) {
                return JoinNode.DistributionType.PARTITIONED;
            }
            return JoinNode.DistributionType.REPLICATED;
        }

        private static boolean mustBroadcastJoin(JoinNode node) {
            return QueryCardinalityUtil.isAtMostScalar(node.getRight()) || Rewriter.isCrossJoin(node);
        }

        private static boolean isCrossJoin(JoinNode node) {
            return node.getType() == JoinNode.Type.INNER && node.getCriteria().isEmpty();
        }
    }
}

