/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SingleMarkDistinctToGroupBy
implements Rule<AggregationNode> {
    private static final Capture<MarkDistinctNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(aggregation -> !SingleMarkDistinctToGroupBy.hasFilters(aggregation)).with(Patterns.source().matching(Patterns.markDistinct().capturedAs(CHILD)));

    private static boolean hasFilters(AggregationNode aggregationNode) {
        return aggregationNode.getAggregations().values().stream().map(AggregationNode.Aggregation::getCall).map(FunctionCall::getFilter).anyMatch(Optional::isPresent);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        MarkDistinctNode child = (MarkDistinctNode)captures.get(CHILD);
        Collection<AggregationNode.Aggregation> aggregations = parent.getAggregations().values();
        List masks = (List)aggregations.stream().map(AggregationNode.Aggregation::getMask).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        ImmutableSet uniqueMasks = ImmutableSet.copyOf((Collection)masks);
        if (uniqueMasks.size() != 1 || masks.size() != aggregations.size()) {
            return Rule.Result.empty();
        }
        Symbol mask = (Symbol)Iterables.getOnlyElement((Iterable)uniqueMasks);
        if (!child.getMarkerSymbol().equals(mask)) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(context.getIdAllocator().getNextId(), new AggregationNode(context.getIdAllocator().getNextId(), child.getSource(), Collections.emptyMap(), (List<List<Symbol>>)ImmutableList.of(child.getDistinctSymbols()), AggregationNode.Step.SINGLE, child.getHashSymbol(), Optional.empty()), parent.getAggregations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SingleMarkDistinctToGroupBy.removeDistinct((AggregationNode.Aggregation)e.getValue()))), parent.getGroupingSets(), parent.getStep(), parent.getHashSymbol(), parent.getGroupIdSymbol()));
    }

    private static AggregationNode.Aggregation removeDistinct(AggregationNode.Aggregation aggregation) {
        FunctionCall call = aggregation.getCall();
        return new AggregationNode.Aggregation(new FunctionCall(call.getName(), call.getWindow(), call.getFilter(), call.getOrderBy(), false, call.getArguments()), aggregation.getSignature(), Optional.empty());
    }
}

