/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.google.common.collect.ImmutableSet;

public class RemoveRedundantIdentityProjections
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(ProjectNode::isIdentity).matching(project -> RemoveRedundantIdentityProjections.outputsSameAsSource(project));

    private static boolean outputsSameAsSource(ProjectNode node) {
        return ImmutableSet.copyOf(node.getOutputSymbols()).equals((Object)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(project.getSource());
    }
}

