/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getValue() instanceof LogicalBinaryExpression) {
                LogicalBinaryExpression child = (LogicalBinaryExpression)node.getValue();
                List<Expression> predicates = ExpressionUtils.extractPredicates(child);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite((Expression)new NotExpression(predicate), (Object)context)).collect(ImmutableList.toImmutableList());
                return ExpressionUtils.combinePredicates(child.getType().flip(), negatedPredicates);
            }
            if (node.getValue() instanceof ComparisonExpression && ((ComparisonExpression)node.getValue()).getType() != ComparisonExpressionType.IS_DISTINCT_FROM) {
                ComparisonExpression child = (ComparisonExpression)node.getValue();
                return new ComparisonExpression(child.getType().negate(), treeRewriter.rewrite(child.getLeft(), (Object)context), treeRewriter.rewrite(child.getRight(), (Object)context));
            }
            if (node.getValue() instanceof NotExpression) {
                NotExpression child = (NotExpression)node.getValue();
                return treeRewriter.rewrite(child.getValue(), (Object)context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), (Object)context));
        }
    }
}

