/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Objects;

public final class PreconditionRules {
    private PreconditionRules() {
    }

    public static Rule<ExchangeNode> checkRulesAreFiredBeforeAddExchangesRule() {
        return PreconditionRules.checkPlanDoNotMatch(Patterns.exchange(), "Expected rules to be fired before 'AddExchanges' optimizer");
    }

    public static <T extends PlanNode> Rule<T> checkPlanDoNotMatch(final Pattern<T> pattern, final String message) {
        Objects.requireNonNull(pattern, "pattern is null");
        Objects.requireNonNull(message, "message is null");
        return new Rule<T>(){

            @Override
            public Pattern<T> getPattern() {
                return pattern;
            }

            @Override
            public Rule.Result apply(T node, Captures captures, Rule.Context context) {
                throw new IllegalStateException(message);
            }
        };
    }
}

