/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PreconditionRules;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PickTableLayout {
    private final Metadata metadata;

    public PickTableLayout(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(PreconditionRules.checkRulesAreFiredBeforeAddExchangesRule(), (Object)this.pickTableLayoutForPredicate(), (Object)this.pickTableLayoutWithoutPredicate());
    }

    public PickTableLayoutForPredicate pickTableLayoutForPredicate() {
        return new PickTableLayoutForPredicate(this.metadata);
    }

    public PickTableLayoutWithoutPredicate pickTableLayoutWithoutPredicate() {
        return new PickTableLayoutWithoutPredicate(this.metadata);
    }

    private static PlanNode planTableScan(TableScanNode node, Expression predicate, Rule.Context context, Metadata metadata) {
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(metadata, context.getSession(), deterministicPredicate, context.getSymbolAllocator().getTypes());
        TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
        List layouts = metadata.getLayouts(context.getSession(), node.getTable(), (Constraint<ColumnHandle>)new Constraint(simplifiedConstraint, bindings -> true), Optional.of(ImmutableSet.copyOf(node.getAssignments().values())));
        if (layouts.isEmpty()) {
            return new ValuesNode(context.getIdAllocator().getNextId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of());
        }
        layouts = (List)layouts.stream().filter(layout -> layout.hasAllOutputs(node)).collect(ImmutableList.toImmutableList());
        TableLayoutResult layout2 = (TableLayoutResult)layouts.get(0);
        TableScanNode result = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(layout2.getLayout().getHandle()), (TupleDomain<ColumnHandle>)simplifiedConstraint.intersect(layout2.getLayout().getPredicate()), Optional.ofNullable(node.getOriginalConstraint()).orElse(predicate));
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        Expression[] expressionArray = new Expression[3];
        expressionArray[0] = decomposedPredicate.getRemainingExpression();
        expressionArray[1] = ExpressionUtils.filterNonDeterministicConjuncts(predicate);
        expressionArray[2] = DomainTranslator.toPredicate((TupleDomain<Symbol>)layout2.getUnenforcedConstraint().transform(((Map)assignments)::get));
        Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(context.getIdAllocator().getNextId(), result, resultingPredicate);
        }
        return result;
    }

    private static final class PickTableLayoutWithoutPredicate
    implements Rule<TableScanNode> {
        private final Metadata metadata;
        private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();

        private PickTableLayoutWithoutPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            if (tableScanNode.getLayout().isPresent()) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(PickTableLayout.planTableScan(tableScanNode, (Expression)BooleanLiteral.TRUE_LITERAL, context, this.metadata));
        }
    }

    private static final class PickTableLayoutForPredicate
    implements Rule<FilterNode> {
        private final Metadata metadata;
        private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));

        private PickTableLayoutForPredicate(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            PlanNode rewritten;
            TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
            if (this.arePlansSame(filterNode, tableScan, rewritten = PickTableLayout.planTableScan(tableScan, filterNode.getPredicate(), context, this.metadata))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewritten);
        }

        private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
            if (!(rewritten instanceof FilterNode)) {
                return false;
            }
            FilterNode rewrittenFilter = (FilterNode)rewritten;
            if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
                return false;
            }
            if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
                return false;
            }
            TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
            return Objects.equals(tableScan.getCurrentConstraint(), rewrittenTableScan.getCurrentConstraint());
        }
    }
}

