/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.util.AstUtils;
import com.facebook.presto.util.MorePredicates;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final Session session;
    private final List<Expression> parameters;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session, List<Expression> parameters) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(parameters, "parameters is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.session = session;
        this.parameters = parameters;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, true);
        }
        return builder;
    }

    public PlanBuilder handleUncorrelatedSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, false);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node) {
        return this.handleSubqueries(builder, expression, node, true);
    }

    private PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node, boolean correlationAllowed) {
        builder = this.appendInPredicateApplyNodes(builder, this.collectInPredicateSubqueries(expression, node), correlationAllowed, node);
        builder = this.appendScalarSubqueryApplyNodes(builder, this.collectScalarSubqueries(expression, node), correlationAllowed);
        builder = this.appendExistsSubqueryApplyNodes(builder, this.collectExistsSubqueries(expression, node), correlationAllowed);
        builder = this.appendQuantifiedComparisonApplyNodes(builder, this.collectQuantifiedComparisonSubqueries(expression, node), correlationAllowed, node);
        return builder;
    }

    public Set<InPredicate> collectInPredicateSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getInPredicateSubqueries(node).stream().filter(inPredicate -> AstUtils.nodeContains((Node)expression, (Node)inPredicate.getValueList())).collect(ImmutableSet.toImmutableSet());
    }

    public Set<SubqueryExpression> collectScalarSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getScalarSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<ExistsPredicate> collectExistsSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getExistsSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<QuantifiedComparisonExpression> collectQuantifiedComparisonSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getQuantifiedComparisonSubqueries(node).stream().filter(quantifiedComparison -> AstUtils.nodeContains((Node)expression, (Node)quantifiedComparison.getSubquery())).collect(ImmutableSet.toImmutableSet());
    }

    private PlanBuilder appendInPredicateApplyNodes(PlanBuilder subPlan, Set<InPredicate> inPredicates, boolean correlationAllowed, Node node) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed, node);
        }
        return subPlan;
    }

    private PlanBuilder appendInPredicateApplyNode(PlanBuilder subPlan, InPredicate inPredicate, boolean correlationAllowed, Node node) {
        if (subPlan.canTranslate((Expression)inPredicate)) {
            return subPlan;
        }
        subPlan = this.handleSubqueries(subPlan, inPredicate.getValue(), node);
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression valueListSubquery = (SubqueryExpression)inPredicate.getValueList();
        SubqueryExpression uncoercedValueListSubquery = this.uncoercedSubquery(valueListSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedValueListSubquery);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)valueListSubquery), this.symbolAllocator, this.idAllocator);
        SymbolReference valueList = subqueryPlan.translate((Expression)valueListSubquery).toSymbolReference();
        InPredicate parametersReplaced = (InPredicate)ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.parameters, this.analysis), (Expression)inPredicate);
        InPredicate inPredicateSubqueryExpression = new InPredicate((Expression)subPlan.translate(parametersReplaced.getValue()).toSymbolReference(), (Expression)valueList);
        Symbol inPredicateSubquerySymbol = this.symbolAllocator.newSymbol((Expression)inPredicateSubqueryExpression, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)parametersReplaced, inPredicateSubquerySymbol);
        subPlan.getTranslations().put((Expression)inPredicate, inPredicateSubquerySymbol);
        return this.appendApplyNode(subPlan, (Node)inPredicate, subqueryPlan, Assignments.of(inPredicateSubquerySymbol, (Expression)inPredicateSubqueryExpression), correlationAllowed);
    }

    private PlanBuilder appendScalarSubqueryApplyNodes(PlanBuilder builder, Set<SubqueryExpression> scalarSubqueries, boolean correlationAllowed) {
        for (SubqueryExpression scalarSubquery : scalarSubqueries) {
            builder = this.appendScalarSubqueryApplyNode(builder, scalarSubquery, correlationAllowed);
        }
        return builder;
    }

    private PlanBuilder appendScalarSubqueryApplyNode(PlanBuilder subPlan, SubqueryExpression scalarSubquery, boolean correlationAllowed) {
        if (subPlan.canTranslate((Expression)scalarSubquery)) {
            return subPlan;
        }
        List<Expression> coercions = this.coercionsFor((Expression)scalarSubquery);
        SubqueryExpression uncoercedScalarSubquery = this.uncoercedSubquery(scalarSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedScalarSubquery);
        subqueryPlan = subqueryPlan.withNewRoot(new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan.getRoot()));
        subqueryPlan = subqueryPlan.appendProjections(coercions, this.symbolAllocator, this.idAllocator);
        Symbol uncoercedScalarSubquerySymbol = subqueryPlan.translate((Expression)uncoercedScalarSubquery);
        subPlan.getTranslations().put((Expression)uncoercedScalarSubquery, uncoercedScalarSubquerySymbol);
        for (Expression coercion : coercions) {
            Symbol coercionSymbol = subqueryPlan.translate(coercion);
            subPlan.getTranslations().put(coercion, coercionSymbol);
        }
        return this.appendLateralJoin(subPlan, subqueryPlan, scalarSubquery.getQuery(), correlationAllowed);
    }

    public PlanBuilder appendLateralJoin(PlanBuilder subPlan, PlanBuilder subqueryPlan, Query query, boolean correlationAllowed) {
        PlanNode subqueryNode = subqueryPlan.getRoot();
        Map<Expression, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode);
        if (!correlationAllowed && !correlation.isEmpty()) {
            throw SemanticExceptions.notSupportedException((Node)query, "Correlated subquery in given context");
        }
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation);
        return new PlanBuilder(subPlan.copyTranslations(), new LateralJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), subqueryNode, (List<Symbol>)ImmutableList.copyOf(SymbolsExtractor.extractUnique(correlation.values())), LateralJoinNode.Type.INNER, (Node)query), this.analysis.getParameters());
    }

    private PlanBuilder appendExistsSubqueryApplyNodes(PlanBuilder builder, Set<ExistsPredicate> existsPredicates, boolean correlationAllowed) {
        for (ExistsPredicate existsPredicate : existsPredicates) {
            builder = this.appendExistSubqueryApplyNode(builder, existsPredicate, correlationAllowed);
        }
        return builder;
    }

    private PlanBuilder appendExistSubqueryApplyNode(PlanBuilder subPlan, ExistsPredicate existsPredicate, boolean correlationAllowed) {
        if (subPlan.canTranslate((Expression)existsPredicate)) {
            return subPlan;
        }
        PlanBuilder subqueryPlan = this.createPlanBuilder(existsPredicate.getSubquery());
        PlanNode subqueryPlanRoot = subqueryPlan.getRoot();
        if (SubqueryPlanner.isAggregationWithEmptyGroupBy(subqueryPlanRoot)) {
            subPlan.getTranslations().put((Expression)existsPredicate, (Expression)BooleanLiteral.TRUE_LITERAL);
            return subPlan;
        }
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)existsPredicate, exists);
        ExistsPredicate rewrittenExistsPredicate = new ExistsPredicate((Expression)subqueryPlanRoot.getOutputSymbols().get(0).toSymbolReference());
        return this.appendApplyNode(subPlan, existsPredicate.getSubquery(), subqueryPlan, Assignments.of(exists, (Expression)rewrittenExistsPredicate), correlationAllowed);
    }

    private PlanBuilder appendQuantifiedComparisonApplyNodes(PlanBuilder subPlan, Set<QuantifiedComparisonExpression> quantifiedComparisons, boolean correlationAllowed, Node node) {
        for (QuantifiedComparisonExpression quantifiedComparison : quantifiedComparisons) {
            subPlan = this.appendQuantifiedComparisonApplyNode(subPlan, quantifiedComparison, correlationAllowed, node);
        }
        return subPlan;
    }

    private PlanBuilder appendQuantifiedComparisonApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed, Node node) {
        if (subPlan.canTranslate((Expression)quantifiedComparison)) {
            return subPlan;
        }
        switch (quantifiedComparison.getComparisonType()) {
            case EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        return this.planQuantifiedApplyNode(subPlan, quantifiedComparison, correlationAllowed);
                    }
                    case ANY: 
                    case SOME: {
                        InPredicate inPredicate = new InPredicate(quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed, node);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.translate((Expression)inPredicate));
                        return subPlan;
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        QuantifiedComparisonExpression rewrittenAny = new QuantifiedComparisonExpression(ComparisonExpressionType.EQUAL, QuantifiedComparisonExpression.Quantifier.ANY, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAny = new NotExpression((Expression)rewrittenAny);
                        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)notAny);
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAny, correlationAllowed, node);
                    }
                    case ANY: 
                    case SOME: {
                        QuantifiedComparisonExpression rewrittenAll = new QuantifiedComparisonExpression(ComparisonExpressionType.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAll = new NotExpression((Expression)rewrittenAll);
                        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)notAll);
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAll, correlationAllowed, node);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.planQuantifiedApplyNode(subPlan, quantifiedComparison, correlationAllowed);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", quantifiedComparison.getComparisonType().getValue(), quantifiedComparison.getQuantifier()));
    }

    private PlanBuilder planQuantifiedApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedComparison.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(quantifiedComparison.getSubquery() instanceof SubqueryExpression));
        SubqueryExpression quantifiedSubquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        SubqueryExpression uncoercedQuantifiedSubquery = this.uncoercedSubquery(quantifiedSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedQuantifiedSubquery);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedSubquery), this.symbolAllocator, this.idAllocator);
        QuantifiedComparisonExpression coercedQuantifiedComparison = new QuantifiedComparisonExpression(quantifiedComparison.getComparisonType(), quantifiedComparison.getQuantifier(), (Expression)subPlan.translate(quantifiedComparison.getValue()).toSymbolReference(), (Expression)subqueryPlan.translate((Expression)quantifiedSubquery).toSymbolReference());
        Symbol coercedQuantifiedComparisonSymbol = this.symbolAllocator.newSymbol((Expression)coercedQuantifiedComparison, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)quantifiedComparison, coercedQuantifiedComparisonSymbol);
        return this.appendApplyNode(subPlan, (Node)quantifiedComparison.getSubquery(), subqueryPlan, Assignments.of(coercedQuantifiedComparisonSymbol, (Expression)coercedQuantifiedComparison), correlationAllowed);
    }

    private static boolean isAggregationWithEmptyGroupBy(PlanNode planNode) {
        return PlanNodeSearcher.searchFrom(planNode).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class)).where(AggregationNode.class::isInstance).findFirst().map(AggregationNode.class::cast).map(aggregation -> aggregation.getGroupingKeys().isEmpty()).orElse(false);
    }

    private SubqueryExpression uncoercedSubquery(SubqueryExpression subquery) {
        return new SubqueryExpression(subquery.getQuery());
    }

    private List<Expression> coercionsFor(Expression expression) {
        return (List)this.analysis.getCoercions().keySet().stream().map(NodeRef::getNode).filter(coercionExpression -> coercionExpression.equals((Object)expression)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder appendApplyNode(PlanBuilder subPlan, Node subquery, PlanBuilder subqueryPlan, Assignments subqueryAssignments, boolean correlationAllowed) {
        PlanNode subqueryNode = subqueryPlan.getRoot();
        Map<Expression, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode);
        if (!correlationAllowed && !correlation.isEmpty()) {
            throw SemanticExceptions.notSupportedException(subquery, "Correlated subquery in given context");
        }
        subPlan = subPlan.appendProjections(correlation.keySet(), this.symbolAllocator, this.idAllocator);
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation);
        TranslationMap translations = subPlan.copyTranslations();
        PlanNode root = subPlan.getRoot();
        return new PlanBuilder(translations, new ApplyNode(this.idAllocator.getNextId(), root, subqueryNode, subqueryAssignments, (List<Symbol>)ImmutableList.copyOf(SymbolsExtractor.extractUnique(correlation.values())), subquery), this.analysis.getParameters());
    }

    private Map<Expression, Expression> extractCorrelation(PlanBuilder subPlan, PlanNode subquery) {
        Set<Expression> missingReferences = this.extractOuterColumnReferences(subquery);
        ImmutableMap.Builder correlation = ImmutableMap.builder();
        for (Expression missingReference : missingReferences) {
            SubqueryPlanner.tryResolveMissingExpression(subPlan, missingReference).ifPresent(symbolReference -> correlation.put((Object)missingReference, symbolReference));
        }
        return correlation.build();
    }

    private static Optional<Expression> tryResolveMissingExpression(PlanBuilder subPlan, Expression expression) {
        Expression rewritten = subPlan.rewrite(expression);
        if (rewritten != expression) {
            return Optional.of(rewritten);
        }
        return Optional.empty();
    }

    private PlanBuilder createPlanBuilder(Node node) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process(node, null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        if (node instanceof Expression && relationPlan.getFieldMappings().size() == 1) {
            translations.put((Expression)node, (Symbol)Iterables.getOnlyElement(relationPlan.getFieldMappings()));
        }
        return new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
    }

    private Set<Expression> extractOuterColumnReferences(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> SubqueryPlanner.extractColumnReferences(expression, this.analysis.getColumnReferences()).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<Expression> extractColumnReferences(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder expressionColumnReferences = ImmutableSet.builder();
        new ColumnReferencesExtractor(columnReferences).process((Node)expression, expressionColumnReferences);
        return expressionColumnReferences.build();
    }

    private PlanNode replaceExpressionsWithSymbols(PlanNode planNode, Map<Expression, Expression> mapping) {
        if (mapping.isEmpty()) {
            return planNode;
        }
        return SimplePlanRewriter.rewriteWith(new ExpressionReplacer(this.idAllocator, mapping), planNode, null);
    }

    private static class ExpressionReplacer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Map<Expression, Expression> mapping;

        public ExpressionReplacer(PlanNodeIdAllocator idAllocator, Map<Expression, Expression> mapping) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ProjectNode rewrittenNode = (ProjectNode)context.defaultRewrite(node);
            Assignments assignments = rewrittenNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, this.mapping));
            return new ProjectNode(this.idAllocator.getNextId(), rewrittenNode.getSource(), assignments);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            FilterNode rewrittenNode = (FilterNode)context.defaultRewrite(node);
            return new FilterNode(this.idAllocator.getNextId(), rewrittenNode.getSource(), ExpressionNodeInliner.replaceExpression(rewrittenNode.getPredicate(), this.mapping));
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ValuesNode rewrittenNode = (ValuesNode)context.defaultRewrite(node);
            List rewrittenRows = (List)rewrittenNode.getRows().stream().map(row -> (ImmutableList)row.stream().map(column -> ExpressionNodeInliner.replaceExpression(column, this.mapping)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            return new ValuesNode(this.idAllocator.getNextId(), rewrittenNode.getOutputSymbols(), rewrittenRows);
        }
    }

    private static class ColumnReferencesExtractor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<Expression>> {
        private final Set<NodeRef<Expression>> columnReferences;

        private ColumnReferencesExtractor(Set<NodeRef<Expression>> columnReferences) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<Expression> builder) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                builder.add((Object)node);
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<Expression> builder) {
            builder.add((Object)node);
            return null;
        }
    }
}

