/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;

public class SchedulingOrderVisitor {
    public static List<PlanNodeId> scheduleOrder(PlanNode root) {
        ImmutableList.Builder schedulingOrder = ImmutableList.builder();
        root.accept(new Visitor(), arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0));
        return schedulingOrder.build();
    }

    private SchedulingOrderVisitor() {
    }

    private static class Visitor
    extends PlanVisitor<Void, Consumer<PlanNodeId>> {
        private Visitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, Consumer<PlanNodeId> schedulingOrder) {
            for (PlanNode source : node.getSources()) {
                source.accept(this, schedulingOrder);
            }
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getRight().accept(this, schedulingOrder);
            node.getLeft().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getFilteringSource().accept(this, schedulingOrder);
            node.getSource().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getIndexSource().accept(this, schedulingOrder);
            node.getProbeSource().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Consumer<PlanNodeId> schedulingOrder) {
            schedulingOrder.accept(node.getId());
            return null;
        }
    }
}

