/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.StatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.AddIntermediateAggregations;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.iterative.rule.CreatePartialTopN;
import com.facebook.presto.sql.planner.iterative.rule.DesugarAtTimeZone;
import com.facebook.presto.sql.planner.iterative.rule.DesugarLambdaExpression;
import com.facebook.presto.sql.planner.iterative.rule.DesugarTryExpression;
import com.facebook.presto.sql.planner.iterative.rule.EliminateCrossJoins;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroLimit;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroSample;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import com.facebook.presto.sql.planner.iterative.rule.ImplementFilteredAggregations;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjections;
import com.facebook.presto.sql.planner.iterative.rule.MergeFilters;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithTopN;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimits;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import com.facebook.presto.sql.planner.iterative.rule.PruneCrossJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneFilterColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneIndexSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneOrderByInAggregation;
import com.facebook.presto.sql.planner.iterative.rule.PruneOutputColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneProjectColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneTopNColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneValuesColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneWindowColumns;
import com.facebook.presto.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughExchange;
import com.facebook.presto.sql.planner.iterative.rule.PushProjectionThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.PushTopNThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.RemoveEmptyDelete;
import com.facebook.presto.sql.planner.iterative.rule.RemoveFullSample;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.iterative.rule.RemoveTrivialFilters;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import com.facebook.presto.sql.planner.iterative.rule.RemoveUnreferencedScalarLateralNodes;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCountOverConstant;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyExpressions;
import com.facebook.presto.sql.planner.iterative.rule.SingleMarkDistinctToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToLateralNode;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedLateralToJoin;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.BeginTableWrite;
import com.facebook.presto.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import com.facebook.presto.sql.planner.optimizations.DesugaringOptimizer;
import com.facebook.presto.sql.planner.optimizations.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.optimizations.DetermineSemiJoinDistributionType;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MetadataDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.TransformCorrelatedNoAggregationSubqueryToJoin;
import com.facebook.presto.sql.planner.optimizations.TransformCorrelatedSingleRowSubqueryToProject;
import com.facebook.presto.sql.planner.optimizations.TransformQuantifiedComparisonApplyToLateralJoin;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class PlanOptimizers {
    private final List<PlanOptimizer> optimizers;
    private final StatsRecorder stats = new StatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig, MBeanExporter exporter, StatsCalculator statsCalculator) {
        this(metadata, sqlParser, featuresConfig, false, exporter, statsCalculator);
    }

    @PostConstruct
    public void initialize() {
        this.stats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.stats.unexport(this.exporter);
    }

    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig, boolean forceSingleNode, MBeanExporter exporter, StatsCalculator statsCalculator) {
        this.exporter = exporter;
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet predicatePushDownRules = ImmutableSet.of((Object)new MergeFilters());
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneCrossJoinColumns(), (Object)new PruneFilterColumns(), (Object)new PruneIndexSourceColumns(), (Object)new PruneJoinChildrenColumns(), (Object[])new Rule[]{new PruneJoinColumns(), new PruneMarkDistinctColumns(), new PruneOutputColumns(), new PruneProjectColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneTopNColumns(), new PruneValuesColumns(), new PruneWindowColumns(), new PruneTableScanColumns()});
        IterativeOptimizer inlineProjections = new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(), (Object)new RemoveRedundantIdentityProjections()));
        IterativeOptimizer projectionPushDown = new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange()));
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(this.stats, statsCalculator, new SimplifyExpressions(metadata, sqlParser).rules());
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.stats, statsCalculator, (List<PlanOptimizer>)ImmutableList.of((Object)new DesugaringOptimizer(metadata, sqlParser)), (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).addAll(new DesugarAtTimeZone(metadata, sqlParser).rules()).addAll(new DesugarTryExpression().rules()).build()), new IterativeOptimizer(this.stats, statsCalculator, new CanonicalizeExpressions().rules()), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)predicatePushDownRules).addAll((Iterable)columnPruningRules).addAll((Iterable)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveFullSample(), (Object)new EvaluateZeroLimit(), (Object)new EvaluateZeroSample(), (Object)new PushLimitThroughProject(), (Object)new MergeLimits(), (Object[])new Rule[]{new MergeLimitWithSort(), new MergeLimitWithTopN(), new PushLimitThroughMarkDistinct(), new PushLimitThroughSemiJoin(), new RemoveTrivialFilters(), new ImplementFilteredAggregations(), new ImplementBernoulliSampleAsFilter(), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(), new PruneOrderByInAggregation(metadata.getFunctionRegistry())})).build()), simplifyOptimizer, new UnaliasSymbolReferences(), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new SetFlatteningOptimizer(), new ImplementIntersectAndExceptAsUnion(), new LimitPushDown(), new PruneUnreferencedOutputs(), inlineProjections, new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToLateralNode(metadata.getFunctionRegistry()))), new TransformQuantifiedComparisonApplyToLateralJoin(metadata), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarLateralNodes(), (Object)new TransformUncorrelatedLateralToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedScalarAggregationToJoin(metadata.getFunctionRegistry()))), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(), (Object)new ImplementFilteredAggregations())), new TransformCorrelatedNoAggregationSubqueryToJoin(), new TransformCorrelatedSingleRowSubqueryToProject(), new CheckSubqueryNodesAreRewritten(), new PredicatePushDown(metadata, sqlParser), new IterativeOptimizer(this.stats, statsCalculator, new PickTableLayout(metadata).rules()), new PruneUnreferencedOutputs(), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PushAggregationThroughOuterJoin())), inlineProjections, simplifyOptimizer, projectionPushDown, new UnaliasSymbolReferences(), new PruneUnreferencedOutputs(), new IndexJoinOptimizer(metadata), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SimplifyCountOverConstant())), new WindowFilterPushDown(metadata), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).build()), inlineProjections, new PruneUnreferencedOutputs(), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new MetadataQueryOptimizer(metadata), new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins())), new PredicatePushDown(metadata, sqlParser), new IterativeOptimizer(this.stats, statsCalculator, new PickTableLayout(metadata).rules()), projectionPushDown});
        if (featuresConfig.isOptimizeSingleDistinct()) {
            builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new SingleMarkDistinctToGroupBy())), new PruneUnreferencedOutputs()});
        }
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughUnion())));
        if (!forceSingleNode) {
            builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (List<PlanOptimizer>)ImmutableList.of((Object)new DetermineJoinDistributionType()), (Set<Rule<?>>)ImmutableSet.of((Object)new com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType())));
            builder.add((Object)new DetermineSemiJoinDistributionType());
            builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new AddExchanges(metadata, sqlParser));
        }
        builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyDelete())));
        builder.add((Object)new PredicatePushDown(metadata, sqlParser));
        builder.add((Object)projectionPushDown);
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences());
        builder.add((Object)new PruneUnreferencedOutputs());
        builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new AddLocalExchanges(metadata, sqlParser));
        builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(metadata.getFunctionRegistry()), (Object)new PruneJoinColumns())));
        builder.add((Object)new IterativeOptimizer(this.stats, statsCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new HashGenerationOptimizer());
        builder.add((Object)new MetadataDeleteOptimizer(metadata));
        builder.add((Object)new BeginTableWrite(metadata));
        this.optimizers = builder.build();
    }

    public List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

