/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ArraySubscriptOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.RowBlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.VarArgsToMapAdapterGenerator;
import com.facebook.presto.sql.planner.DesugarAtTimeZoneRewriter;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.FunctionType;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.FastutilSetHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.airlift.joni.Regex;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExpressionInterpreter {
    private final Expression expression;
    private final Metadata metadata;
    private final ConnectorSession session;
    private final boolean optimize;
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final FunctionInvoker functionInvoker;
    private final Visitor visitor;
    private final IdentityHashMap<LikePredicate, Regex> likePatternCache = new IdentityHashMap();
    private final IdentityHashMap<InListExpression, Set<?>> inListCache = new IdentityHashMap();

    public static ExpressionInterpreter expressionInterpreter(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, false);
    }

    public static ExpressionInterpreter expressionOptimizer(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, true);
    }

    public static Object evaluateConstantExpression(Expression expression, Type expectedType, Metadata metadata, Session session, List<Expression> parameters) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters);
        analyzer.analyze(expression, Scope.create());
        Type actualType = analyzer.getExpressionTypes().get(NodeRef.of((Node)expression));
        if (!metadata.getTypeManager().canCoerce(actualType, expectedType)) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, String.format("Cannot cast type %s to %s", expectedType.getTypeSignature(), actualType.getTypeSignature()), new Object[0]);
        }
        ImmutableMap coercions = ImmutableMap.builder().putAll(analyzer.getExpressionCoercions()).put((Object)NodeRef.of((Node)expression), (Object)expectedType).build();
        return ExpressionInterpreter.evaluateConstantExpression(expression, (Map<NodeRef<Expression>, Type>)coercions, metadata, session, (Set<NodeRef<Expression>>)ImmutableSet.of(), parameters);
    }

    public static Object evaluateConstantExpression(Expression expression, final Map<NodeRef<Expression>, Type> coercions, Metadata metadata, Session session, Set<NodeRef<Expression>> columnReferences, List<Expression> parameters) {
        Objects.requireNonNull(columnReferences, "columnReferences is null");
        ExpressionInterpreter.verifyExpressionIsConstant(columnReferences, expression);
        Expression rewrite = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                Type coerceToType = (Type)coercions.get(NodeRef.of((Node)node));
                if (coerceToType != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coerceToType.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }
        }, (Expression)expression);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters);
        analyzer.analyze(rewrite, Scope.create());
        rewrite = DesugarAtTimeZoneRewriter.rewrite(rewrite, analyzer.getExpressionTypes());
        Expression canonicalized = CanonicalizeExpressionRewriter.canonicalizeExpression(rewrite);
        analyzer = ExpressionAnalyzer.createConstantAnalyzer(metadata, session, parameters);
        analyzer.analyze(canonicalized, Scope.create());
        Object result = ExpressionInterpreter.expressionInterpreter(canonicalized, metadata, session, analyzer.getExpressionTypes()).evaluate(0, new Block[0]);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public static void verifyExpressionIsConstant(Set<NodeRef<Expression>> columnReferences, Expression expression) {
        new ConstantExpressionVerifierVisitor(columnReferences, expression).process((Node)expression, null);
    }

    private ExpressionInterpreter(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> expressionTypes, boolean optimize) {
        this.expression = expression;
        this.metadata = metadata;
        this.session = session.toConnectorSession();
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        Verify.verify((boolean)expressionTypes.containsKey(NodeRef.of((Node)expression)));
        this.optimize = optimize;
        this.functionInvoker = new FunctionInvoker(metadata.getFunctionRegistry());
        this.visitor = new Visitor();
    }

    public Type getType() {
        return this.expressionTypes.get(NodeRef.of((Node)this.expression));
    }

    public Object evaluate(RecordCursor inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(RecordCursor) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public Object evaluate(int position, Block ... inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(int, Block...) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, new SinglePagePositionContext(position, inputs));
    }

    public Object evaluate(int leftPosition, Block[] leftBlocks, int rightPosition, Block[] rightBlocks) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(int, Block[], int, Block[]) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, new TwoPagesPositionContext(leftPosition, leftBlocks, rightPosition, rightBlocks));
    }

    public Object optimize(SymbolResolver inputs) {
        Preconditions.checkState((boolean)this.optimize, (Object)"evaluate(SymbolResolver) not allowed for interpreter");
        return this.visitor.process((Node)this.expression, inputs);
    }

    @VisibleForTesting
    public static Expression createFailureFunction(RuntimeException exception, Type type) {
        Objects.requireNonNull(exception, "Exception is null");
        String failureInfo = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure(exception).toFailureInfo());
        FunctionCall jsonParse = new FunctionCall(QualifiedName.of((String)"json_parse"), (List)ImmutableList.of((Object)new StringLiteral(failureInfo)));
        FunctionCall failureFunction = new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)jsonParse));
        return new Cast((Expression)failureFunction, type.getTypeSignature().toString());
    }

    private static boolean isArray(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    private static class LambdaSymbolResolver
    implements SymbolResolver {
        private final Map<String, Object> values;

        public LambdaSymbolResolver(Map<String, Object> values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @Override
        public Object getValue(Symbol symbol) {
            Preconditions.checkState((boolean)this.values.containsKey(symbol.getName()), (String)"values does not contain %s", (Object)symbol);
            return this.values.get(symbol.getName());
        }
    }

    private static class TwoPagesPositionContext
    implements PagePositionContext {
        private final int leftPosition;
        private final int rightPosition;
        private final Block[] leftBlocks;
        private final Block[] rightBlocks;

        private TwoPagesPositionContext(int leftPosition, Block[] leftBlocks, int rightPosition, Block[] rightBlocks) {
            this.leftPosition = leftPosition;
            this.rightPosition = rightPosition;
            this.leftBlocks = leftBlocks;
            this.rightBlocks = rightBlocks;
        }

        @Override
        public Block getBlock(int channel) {
            if (channel < this.leftBlocks.length) {
                return this.leftBlocks[channel];
            }
            return this.rightBlocks[channel - this.leftBlocks.length];
        }

        @Override
        public int getPosition(int channel) {
            if (channel < this.leftBlocks.length) {
                return this.leftPosition;
            }
            return this.rightPosition;
        }
    }

    private static class SinglePagePositionContext
    implements PagePositionContext {
        private final int position;
        private final Block[] blocks;

        private SinglePagePositionContext(int position, Block[] blocks) {
            this.position = position;
            this.blocks = blocks;
        }

        @Override
        public Block getBlock(int channel) {
            return this.blocks[channel];
        }

        @Override
        public int getPosition(int channel) {
            return this.position;
        }
    }

    private static interface PagePositionContext {
        public Block getBlock(int var1);

        public int getPosition(int var1);
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private Visitor() {
        }

        public Object visitFieldReference(FieldReference node, Object context) {
            Type type = this.type((Expression)node);
            int channel = node.getFieldIndex();
            if (context instanceof PagePositionContext) {
                PagePositionContext pagePositionContext = (PagePositionContext)context;
                int position = pagePositionContext.getPosition(channel);
                Block block = pagePositionContext.getBlock(channel);
                if (block.isNull(position)) {
                    return null;
                }
                Class javaType = type.getJavaType();
                if (javaType == Boolean.TYPE) {
                    return type.getBoolean(block, position);
                }
                if (javaType == Long.TYPE) {
                    return type.getLong(block, position);
                }
                if (javaType == Double.TYPE) {
                    return type.getDouble(block, position);
                }
                if (javaType == Slice.class) {
                    return type.getSlice(block, position);
                }
                if (javaType == Block.class) {
                    return type.getObject(block, position);
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            if (context instanceof RecordCursor) {
                RecordCursor cursor = (RecordCursor)context;
                if (cursor.isNull(channel)) {
                    return null;
                }
                Class javaType = type.getJavaType();
                if (javaType == Boolean.TYPE) {
                    return cursor.getBoolean(channel);
                }
                if (javaType == Long.TYPE) {
                    return cursor.getLong(channel);
                }
                if (javaType == Double.TYPE) {
                    return cursor.getDouble(channel);
                }
                if (javaType == Slice.class) {
                    return cursor.getSlice(channel);
                }
                if (javaType == Block.class) {
                    return cursor.getObject(channel);
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            throw new UnsupportedOperationException("Inputs or cursor must be set");
        }

        protected Object visitDereferenceExpression(DereferenceExpression node, Object context) {
            Type type = this.type(node.getBase());
            if (type == null) {
                return node;
            }
            Object base = this.process((Node)node.getBase(), context);
            if (base == null) {
                return null;
            }
            if (this.hasUnresolvedValue(base)) {
                return new DereferenceExpression(LiteralInterpreter.toExpression(base, type), node.getField());
            }
            RowType rowType = (RowType)type;
            Block row = (Block)base;
            Type returnType = this.type((Expression)node);
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.RowField field = (RowType.RowField)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(node.getField().getValue())) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            if (row.isNull(index)) {
                return null;
            }
            Class javaType = returnType.getJavaType();
            if (javaType == Long.TYPE) {
                return returnType.getLong(row, index);
            }
            if (javaType == Double.TYPE) {
                return returnType.getDouble(row, index);
            }
            if (javaType == Boolean.TYPE) {
                return returnType.getBoolean(row, index);
            }
            if (javaType == Slice.class) {
                return returnType.getSlice(row, index);
            }
            if (!javaType.isPrimitive()) {
                return returnType.getObject(row, index);
            }
            throw new UnsupportedOperationException("Dereference a unsupported primitive type: " + javaType.getName());
        }

        protected Object visitIdentifier(Identifier node, Object context) {
            return ((SymbolResolver)context).getValue(new Symbol(node.getValue()));
        }

        protected Object visitParameter(Parameter node, Object context) {
            return node;
        }

        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((SymbolResolver)context).getValue(Symbol.from((Expression)node));
        }

        protected Object visitLiteral(Literal node, Object context) {
            return LiteralInterpreter.evaluate(ExpressionInterpreter.this.metadata, ExpressionInterpreter.this.session, (Expression)node);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(LiteralInterpreter.toExpression(value, this.type(node.getValue())));
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(LiteralInterpreter.toExpression(value, this.type(node.getValue())));
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object defaultResult = this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                Object result = this.processWithExceptionHandling(whenClause.getResult(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(LiteralInterpreter.toExpression(whenOperand, this.type(whenClause.getOperand())), LiteralInterpreter.toExpression(result, this.type(whenClause.getResult()))));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                defaultResult = result;
                break;
            }
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression resultExpression = defaultResult == null ? null : LiteralInterpreter.toExpression(defaultResult, this.type((Expression)node));
            return new SearchedCaseExpression(whenClauses, Optional.ofNullable(resultExpression));
        }

        protected Object visitIfExpression(IfExpression node, Object context) {
            Object trueValue = this.processWithExceptionHandling(node.getTrueValue(), context);
            Object falseValue = this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
            Object condition = this.processWithExceptionHandling(node.getCondition(), context);
            if (condition instanceof Expression) {
                Expression falseValueExpression = falseValue == null ? null : LiteralInterpreter.toExpression(falseValue, this.type((Expression)node.getFalseValue().get()));
                return new IfExpression(LiteralInterpreter.toExpression(condition, this.type(node.getCondition())), LiteralInterpreter.toExpression(trueValue, this.type(node.getTrueValue())), falseValueExpression);
            }
            if (Boolean.TRUE.equals(condition)) {
                return trueValue;
            }
            return falseValue;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process((Node)expression, context);
            }
            catch (RuntimeException e) {
                return ExpressionInterpreter.createFailureFunction(e, this.type(expression));
            }
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = this.type(node.getOperand());
            Expression defaultClause = node.getDefaultValue().orElse(null);
            Object defaultResult = this.processWithExceptionHandling(defaultClause, context);
            if (operand == null) {
                return defaultResult;
            }
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                Object result = this.processWithExceptionHandling(whenClause.getResult(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(LiteralInterpreter.toExpression(whenOperand, this.type(whenClause.getOperand())), LiteralInterpreter.toExpression(result, this.type(whenClause.getResult()))));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, this.type(whenClause.getOperand()))) continue;
                defaultResult = result;
                break;
            }
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : LiteralInterpreter.toExpression(defaultResult, this.type((Expression)node));
            return new SimpleCaseExpression(LiteralInterpreter.toExpression(operand, this.type(node.getOperand())), whenClauses, Optional.ofNullable(defaultExpression));
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return (Boolean)this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2));
        }

        private Type type(Expression expression) {
            return (Type)ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)expression));
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            Type type = this.type((Expression)node);
            List values = node.getOperands().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).filter(Objects::nonNull).collect(Collectors.toList());
            if (!values.isEmpty() && !(values.get(0) instanceof Expression) || values.size() == 1) {
                return values.get(0);
            }
            List expressions = values.stream().map(value -> LiteralInterpreter.toExpression(value, type)).collect(Collectors.toList());
            if (expressions.isEmpty()) {
                return null;
            }
            return new CoalesceExpression(expressions);
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Expression valueListExpression = node.getValueList();
            if (!(valueListExpression instanceof InListExpression)) {
                if (!ExpressionInterpreter.this.optimize) {
                    throw new UnsupportedOperationException("IN predicate value list type not yet implemented: " + valueListExpression.getClass().getName());
                }
                return node;
            }
            InListExpression valueList = (InListExpression)valueListExpression;
            Set<?> set = (Set<?>)ExpressionInterpreter.this.inListCache.get(valueList);
            if (!ExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                if (valueList.getValues().stream().allMatch(Literal.class::isInstance)) {
                    if (valueList.getValues().stream().noneMatch(NullLiteral.class::isInstance)) {
                        Set objectSet = valueList.getValues().stream().map(expression -> this.process((Node)expression, context)).collect(Collectors.toSet());
                        set = FastutilSetHelper.toFastutilHashSet(objectSet, this.type(node.getValue()), ExpressionInterpreter.this.metadata.getFunctionRegistry());
                    }
                }
                ExpressionInterpreter.this.inListCache.put(valueList, set);
            }
            if (set != null && !(value instanceof Expression)) {
                return set.contains(value);
            }
            boolean hasUnresolvedValue = false;
            if (value instanceof Expression) {
                hasUnresolvedValue = true;
            }
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Type> types = new ArrayList<Type>(valueList.getValues().size());
            for (Expression expression2 : valueList.getValues()) {
                Object inValue = this.process((Node)expression2, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(this.type(expression2));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !((Boolean)this.invokeOperator(OperatorType.EQUAL, this.types(node.getValue(), expression2), (List<Object>)ImmutableList.of((Object)value, (Object)inValue))).booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = this.type(node.getValue());
                List<Expression> expressionValues = LiteralInterpreter.toExpressions(values, types);
                List simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter(DeterminismEvaluator::isDeterministic).distinct(), expressionValues.stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression))).collect(ImmutableList.toImmutableList());
                return new InPredicate(LiteralInterpreter.toExpression(value, type), (Expression)new InListExpression(simplifiedExpressionValues));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitExists(ExistsPredicate node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("Exists subquery not yet implemented");
            }
            return node;
        }

        protected Object visitSubqueryExpression(SubqueryExpression node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("Subquery not yet implemented");
            }
            return node;
        }

        protected Object visitArithmeticUnary(ArithmeticUnaryExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new ArithmeticUnaryExpression(node.getSign(), LiteralInterpreter.toExpression(value, this.type(node.getValue())));
            }
            switch (node.getSign()) {
                case PLUS: {
                    return value;
                }
                case MINUS: {
                    Signature operatorSignature = ExpressionInterpreter.this.metadata.getFunctionRegistry().resolveOperator(OperatorType.NEGATION, this.types(node.getValue()));
                    MethodHandle handle = ExpressionInterpreter.this.metadata.getFunctionRegistry().getScalarFunctionImplementation(operatorSignature).getMethodHandle();
                    if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
                        handle = handle.bindTo(ExpressionInterpreter.this.session);
                    }
                    try {
                        return handle.invokeWithArguments(value);
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                        Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                        throw new RuntimeException(throwable.getMessage(), throwable);
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getType(), LiteralInterpreter.toExpression(left, this.type(node.getLeft())), LiteralInterpreter.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)node.getType().name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpressionType type = node.getType();
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null && type != ComparisonExpressionType.IS_DISTINCT_FROM) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (type == ComparisonExpressionType.IS_DISTINCT_FROM) {
                if (left == null && right == null) {
                    return false;
                }
                if (left == null || right == null) {
                    return true;
                }
            } else if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ComparisonExpression(type, LiteralInterpreter.toExpression(left, this.type(node.getLeft())), LiteralInterpreter.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)type.name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.process((Node)node.getMin(), context);
            if (min == null) {
                return null;
            }
            Object max = this.process((Node)node.getMax(), context);
            if (max == null) {
                return null;
            }
            if (this.hasUnresolvedValue(value, min, max)) {
                return new BetweenPredicate(LiteralInterpreter.toExpression(value, this.type(node.getValue())), LiteralInterpreter.toExpression(min, this.type(node.getMin())), LiteralInterpreter.toExpression(max, this.type(node.getMax())));
            }
            return this.invokeOperator(OperatorType.BETWEEN, this.types(node.getValue(), node.getMin(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)min, (Object)max));
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.process((Node)node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.process((Node)node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = this.type(node.getFirst());
            Type secondType = this.type(node.getSecond());
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(LiteralInterpreter.toExpression(first, firstType), LiteralInterpreter.toExpression(second, secondType));
            }
            Type commonType = (Type)ExpressionInterpreter.this.metadata.getTypeManager().getCommonSuperType(firstType, secondType).get();
            Signature firstCast = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion(firstType, commonType);
            Signature secondCast = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion(secondType, commonType);
            boolean equal = (Boolean)this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.this.functionInvoker.invoke(firstCast, ExpressionInterpreter.this.session, (List<Object>)ImmutableList.of((Object)first)), (Object)ExpressionInterpreter.this.functionInvoker.invoke(secondCast, ExpressionInterpreter.this.session, (List<Object>)ImmutableList.of((Object)second))));
            if (equal) {
                return null;
            }
            return first;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(LiteralInterpreter.toExpression(value, this.type(node.getValue())));
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            Object right = this.process((Node)node.getRight(), context);
            switch (node.getType()) {
                case AND: {
                    if (Boolean.FALSE.equals(left) || Boolean.TRUE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.FALSE.equals(right) && !Boolean.TRUE.equals(left)) break;
                    return right;
                }
                case OR: {
                    if (Boolean.TRUE.equals(left) || Boolean.FALSE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.TRUE.equals(right) && !Boolean.FALSE.equals(left)) break;
                    return right;
                }
            }
            if (left == null && right == null) {
                return null;
            }
            return new LogicalBinaryExpression(node.getType(), LiteralInterpreter.toExpression(left, this.type(node.getLeft())), LiteralInterpreter.toExpression(right, this.type(node.getRight())));
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Object value = this.process((Node)expression, context);
                Type type = this.type(expression);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            Signature functionSignature = ExpressionInterpreter.this.metadata.getFunctionRegistry().resolveFunction(node.getName(), TypeSignatureProvider.fromTypes(argumentTypes));
            ScalarFunctionImplementation function = ExpressionInterpreter.this.metadata.getFunctionRegistry().getScalarFunctionImplementation(functionSignature);
            for (int i = 0; i < argumentValues.size(); ++i) {
                Object value = argumentValues.get(i);
                if (value != null || function.getArgumentProperty(i).getNullConvention() != ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL) continue;
                return null;
            }
            if (ExpressionInterpreter.this.optimize && (!function.isDeterministic() || this.hasUnresolvedValue(argumentValues) || node.getName().equals((Object)QualifiedName.of((String)"fail")))) {
                return new FunctionCall(node.getName(), node.getWindow(), node.isDistinct(), LiteralInterpreter.toExpressions(argumentValues, argumentTypes));
            }
            return ExpressionInterpreter.this.functionInvoker.invoke(functionSignature, ExpressionInterpreter.this.session, argumentValues);
        }

        protected Object visitLambdaExpression(LambdaExpression node, Object context) {
            if (ExpressionInterpreter.this.optimize) {
                return node;
            }
            Expression body = node.getBody();
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            FunctionType functionType = (FunctionType)ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)node));
            Preconditions.checkArgument((argumentNames.size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), argumentNames, map -> this.process((Node)body, new LambdaSymbolResolver((Map<String, Object>)map)));
        }

        protected Object visitBindExpression(BindExpression node, Object context) {
            List values = (List)node.getValues().stream().map(value -> this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Object function = this.process((Node)node.getFunction(), context);
            if (this.hasUnresolvedValue(values) || this.hasUnresolvedValue(function)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    builder.add((Object)LiteralInterpreter.toExpression(values.get(i), this.type((Expression)node.getValues().get(i))));
                }
                return new BindExpression((List)builder.build(), LiteralInterpreter.toExpression(function, this.type(node.getFunction())));
            }
            return MethodHandles.insertArguments((MethodHandle)function, 0, values.toArray());
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Slice && node.getPattern() instanceof StringLiteral && (node.getEscape() instanceof StringLiteral || node.getEscape() == null)) {
                return LikeFunctions.like((Slice)value, this.getConstantPattern(node));
            }
            Object pattern = this.process((Node)node.getPattern(), context);
            if (pattern == null) {
                return null;
            }
            Object escape = null;
            if (node.getEscape() != null && (escape = this.process((Node)node.getEscape(), context)) == null) {
                return null;
            }
            if (value instanceof Slice && pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                Regex regex = escape == null ? LikeFunctions.likePattern((Slice)pattern) : LikeFunctions.likePattern((Slice)pattern, (Slice)escape);
                return LikeFunctions.like((Slice)value, regex);
            }
            if (pattern instanceof Slice && (escape == null || escape instanceof Slice) && !LikeFunctions.isLikePattern((Slice)pattern, (Slice)escape)) {
                Slice unescapedPattern = LikeFunctions.unescapeLiteralLikePattern((Slice)pattern, (Slice)escape);
                Type valueType = this.type(node.getValue());
                VarcharType patternType = VarcharType.createVarcharType((int)unescapedPattern.length());
                TypeManager typeManager = ExpressionInterpreter.this.metadata.getTypeManager();
                Optional commonSuperType = typeManager.getCommonSuperType(valueType, (Type)patternType);
                Preconditions.checkArgument((boolean)commonSuperType.isPresent(), (String)"Missing super type when optimizing %s", (Object)node);
                Expression valueExpression = LiteralInterpreter.toExpression(value, valueType);
                Expression patternExpression = LiteralInterpreter.toExpression(unescapedPattern, (Type)patternType);
                Type superType = (Type)commonSuperType.get();
                if (!valueType.equals(superType)) {
                    valueExpression = new Cast(valueExpression, superType.getTypeSignature().toString(), false, typeManager.isTypeOnlyCoercion(valueType, superType));
                }
                if (!patternType.equals(superType)) {
                    patternExpression = new Cast(patternExpression, superType.getTypeSignature().toString(), false, typeManager.isTypeOnlyCoercion((Type)patternType, superType));
                }
                return new ComparisonExpression(ComparisonExpressionType.EQUAL, valueExpression, patternExpression);
            }
            Expression optimizedEscape = null;
            if (node.getEscape() != null) {
                optimizedEscape = LiteralInterpreter.toExpression(escape, this.type(node.getEscape()));
            }
            return new LikePredicate(LiteralInterpreter.toExpression(value, this.type(node.getValue())), LiteralInterpreter.toExpression(pattern, this.type(node.getPattern())), optimizedEscape);
        }

        private Regex getConstantPattern(LikePredicate node) {
            Regex result = (Regex)ExpressionInterpreter.this.likePatternCache.get(node);
            if (result == null) {
                StringLiteral pattern = (StringLiteral)node.getPattern();
                StringLiteral escape = (StringLiteral)node.getEscape();
                result = escape == null ? LikeFunctions.likePattern(pattern.getSlice()) : LikeFunctions.likePattern(pattern.getSlice(), escape.getSlice());
                ExpressionInterpreter.this.likePatternCache.put(node, result);
            }
            return result;
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.process((Node)node.getExpression(), context);
            Type targetType = ExpressionInterpreter.this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (targetType == null) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            Type sourceType = this.type(node.getExpression());
            if (value instanceof Expression) {
                if (targetType.equals(sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe(), node.isTypeOnly());
            }
            if (node.isTypeOnly()) {
                return value;
            }
            if (ExpressionInterpreter.this.optimize && !FunctionRegistry.isSupportedLiteralType(this.type((Expression)node))) {
                return new Cast(LiteralInterpreter.toExpression(value, sourceType), node.getType(), node.isSafe(), node.isTypeOnly());
            }
            if (value == null) {
                return null;
            }
            Signature operator = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion(sourceType, targetType);
            try {
                return ExpressionInterpreter.this.functionInvoker.invoke(operator, ExpressionInterpreter.this.session, (List<Object>)ImmutableList.of((Object)value));
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        protected Object visitArrayConstructor(ArrayConstructor node, Object context) {
            Type elementType = ((ArrayType)this.type((Expression)node)).getElementType();
            BlockBuilder arrayBlockBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), node.getValues().size());
            for (Expression expression : node.getValues()) {
                Object value = this.process((Node)expression, context);
                if (value instanceof Expression) {
                    return this.visitFunctionCall(new FunctionCall(QualifiedName.of((String)"ARRAY_CONSTRUCTOR"), node.getValues()), context);
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)arrayBlockBuilder, (Object)value);
            }
            return arrayBlockBuilder.build();
        }

        protected Object visitRow(Row node, Object context) {
            RowType rowType = (RowType)this.type((Expression)node);
            List parameterTypes = rowType.getTypeParameters();
            List arguments = node.getItems();
            int cardinality = arguments.size();
            ArrayList<Object> values = new ArrayList<Object>(cardinality);
            for (Expression argument : arguments) {
                values.add(this.process((Node)argument, context));
            }
            if (this.hasUnresolvedValue(values)) {
                return new Row(LiteralInterpreter.toExpressions(values, parameterTypes));
            }
            RowBlockBuilder blockBuilder = new RowBlockBuilder(parameterTypes, new BlockBuilderStatus(), 1);
            BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
            for (int i = 0; i < cardinality; ++i) {
                TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)singleRowBlockWriter, values.get(i));
            }
            blockBuilder.closeEntry();
            return rowType.getObject((Block)blockBuilder, 0);
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.process((Node)node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.process((Node)node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (index instanceof Long && ExpressionInterpreter.isArray(this.type(node.getBase()))) {
                ArraySubscriptOperator.checkArrayIndex((Long)index);
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(LiteralInterpreter.toExpression(base, this.type(node.getBase())), LiteralInterpreter.toExpression(index, this.type(node.getIndex())));
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        protected Object visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Object context) {
            if (!ExpressionInterpreter.this.optimize) {
                throw new UnsupportedOperationException("QuantifiedComparison not yet implemented");
            }
            return node;
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        protected Object visitNode(Node node, Object context) {
            throw new UnsupportedOperationException("Evaluator visitor can only handle Expression nodes");
        }

        private List<Type> types(Expression ... types) {
            return (List)Stream.of(types).map(NodeRef::of).map(ExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(arg_0 -> ((Predicate)Predicates.instanceOf(Expression.class)).apply(arg_0));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            Signature operatorSignature = ExpressionInterpreter.this.metadata.getFunctionRegistry().resolveOperator(operatorType, argumentTypes);
            return ExpressionInterpreter.this.functionInvoker.invoke(operatorSignature, ExpressionInterpreter.this.session, argumentValues);
        }
    }

    private static class ConstantExpressionVerifierVisitor
    extends DefaultTraversalVisitor<Void, Void> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final Expression expression;

        public ConstantExpressionVerifierVisitor(Set<NodeRef<Expression>> columnReferences, Expression expression) {
            this.columnReferences = columnReferences;
            this.expression = expression;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
            }
            this.process((Node)node.getBase(), context);
            return null;
        }

        protected Void visitIdentifier(Identifier node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }

        protected Void visitFieldReference(FieldReference node, Void context) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }
    }
}

