/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.RowExpression;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BytecodeGeneratorContext {
    private final RowExpressionCompiler rowExpressionCompiler;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final FunctionRegistry registry;
    private final PreGeneratedExpressions preGeneratedExpressions;
    private final Variable wasNull;

    public BytecodeGeneratorContext(RowExpressionCompiler rowExpressionCompiler, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionRegistry registry, PreGeneratedExpressions preGeneratedExpressions) {
        Objects.requireNonNull(rowExpressionCompiler, "bytecodeGenerator is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(registry, "registry is null");
        this.rowExpressionCompiler = rowExpressionCompiler;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.registry = registry;
        this.preGeneratedExpressions = preGeneratedExpressions;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression) {
        return this.generate(expression, Optional.empty());
    }

    public BytecodeNode generate(RowExpression expression, Optional<Class> lambdaInterface) {
        return this.rowExpressionCompiler.compile(expression, this.scope, lambdaInterface);
    }

    public FunctionRegistry getRegistry() {
        return this.registry;
    }

    public BytecodeNode generateCall(String name, ScalarFunctionImplementation function, List<BytecodeNode> arguments) {
        Binding binding = this.callSiteBinder.bind(function.getMethodHandle());
        Optional<BytecodeNode> instance = Optional.empty();
        if (function.getInstanceFactory().isPresent()) {
            FieldDefinition field = this.cachedInstanceBinder.getCachedInstance(function.getInstanceFactory().get());
            instance = Optional.of(this.scope.getThis().getField(field));
        }
        return BytecodeUtils.generateInvocation(this.scope, name, function, instance, arguments, binding);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

