/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeNode;
import java.util.List;
import java.util.Map;

public class BindCodeGenerator
implements BytecodeGenerator {
    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap;
    private Class lambdaInterface;

    public BindCodeGenerator(Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, Class lambdaInterface) {
        this.compiledLambdaMap = compiledLambdaMap;
        this.lambdaInterface = lambdaInterface;
    }

    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        int numCaptures = arguments.size() - 1;
        LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)arguments.get(numCaptures);
        Preconditions.checkState((boolean)this.compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
        LambdaBytecodeGenerator.CompiledLambda compiledLambda = this.compiledLambdaMap.get(lambda);
        return LambdaBytecodeGenerator.generateLambda(context, arguments.subList(0, numCaptures), compiledLambda, this.lambdaInterface);
    }
}

