/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import java.util.List;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"http.server.authentication.enabled"})
public class SecurityConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<AuthenticationType> authenticationTypes = ImmutableList.of();

    @NotNull
    public List<AuthenticationType> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public SecurityConfig setAuthenticationTypes(List<AuthenticationType> authenticationTypes) {
        this.authenticationTypes = ImmutableList.copyOf(authenticationTypes);
        return this;
    }

    @Config(value="http-server.authentication.type")
    @ConfigDescription(value="Authentication types (supported types: CERTIFICATE, KERBEROS, PASSWORD)")
    public SecurityConfig setAuthenticationTypes(String types) {
        if (types == null) {
            this.authenticationTypes = null;
            return this;
        }
        this.authenticationTypes = (List)Streams.stream((Iterable)SPLITTER.split((CharSequence)types)).map(AuthenticationType::valueOf).collect(ImmutableList.toImmutableList());
        return this;
    }

    public static enum AuthenticationType {
        CERTIFICATE,
        KERBEROS,
        PASSWORD;

    }
}

