/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.ClientTypeSignature;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.protocol.RowIterable;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private static final long DESIRED_RESULT_BYTES = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private final QueryManager queryManager;
    private final QueryId queryId;
    @GuardedBy(value="this")
    private final ExchangeClient exchangeClient;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    @GuardedBy(value="this")
    private final PagesSerde serde;
    private final AtomicLong resultId = new AtomicLong();
    private final Session session;
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private String lastResultPath;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog;
    @GuardedBy(value="this")
    private Optional<String> setSchema;
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties;
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties;
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements;
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements;
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId;
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Long updateCount;

    public static Query create(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Query result = new Query(sessionContext, query, queryManager, sessionPropertyManager, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
        result.queryManager.addOutputInfoListener(result.queryId, result::setQueryOutputInfo);
        return result;
    }

    private Query(SessionContext sessionContext, String query, QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Objects.requireNonNull(sessionContext, "sessionContext is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.queryManager = queryManager;
        QueryInfo queryInfo = queryManager.createQuery(sessionContext, query);
        this.queryId = queryInfo.getQueryId();
        this.session = queryInfo.getSession().toSession(sessionPropertyManager);
        this.exchangeClient = exchangeClient;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        Objects.requireNonNull(blockEncodingSerde, "serde is null");
        this.serde = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(this.session)).createPagesSerde();
    }

    public void cancel() {
        this.queryManager.cancelQuery(this.queryId);
        this.dispose();
    }

    public synchronized void dispose() {
        this.exchangeClient.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public synchronized Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    public synchronized Optional<String> getSetSchema() {
        return this.setSchema;
    }

    public synchronized Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public synchronized Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public synchronized Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public synchronized Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public synchronized Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    public synchronized boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    public synchronized ListenableFuture<QueryResults> waitForResults(OptionalLong token, UriInfo uriInfo, Duration wait) {
        Optional<QueryResults> cachedResult;
        if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
            return Futures.immediateFuture((Object)cachedResult.get());
        }
        ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo), (Executor)this.resultsProcessorExecutor);
    }

    private synchronized ListenableFuture<?> getFutureStateChange() {
        if (!this.exchangeClient.isClosed()) {
            return this.exchangeClient.isBlocked();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        return this.queryManager.getQueryState(this.queryId).map(this::queryDoneFuture).orElse(Futures.immediateFuture(null));
    }

    private synchronized Optional<QueryResults> getCachedResult(long token, UriInfo uriInfo) {
        String requestedPath = uriInfo.getAbsolutePath().getPath();
        if (this.lastResultPath != null && requestedPath.equals(this.lastResultPath)) {
            this.queryManager.getQueryInfo(this.queryId);
            this.queryManager.recordHeartbeat(this.queryId);
            return Optional.of(this.lastResult);
        }
        if (token < this.resultId.get()) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (this.lastResult.getNextUri() == null || !requestedPath.equals(this.lastResult.getNextUri().getPath())) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    private synchronized QueryResults getNextResult(OptionalLong token, UriInfo uriInfo) {
        Number number;
        Iterator iterator;
        Optional<QueryResults> cachedResult;
        if (token.isPresent() && (cachedResult = this.getCachedResult(token.getAsLong(), uriInfo)).isPresent()) {
            return cachedResult.get();
        }
        Iterable data = null;
        try {
            SerializedPage serializedPage;
            ImmutableList.Builder pages = ImmutableList.builder();
            long bytes = 0L;
            long rows = 0L;
            while (bytes < DESIRED_RESULT_BYTES && (serializedPage = this.exchangeClient.pollPage()) != null) {
                Page page = this.serde.deserialize(serializedPage);
                bytes += page.getSizeInBytes();
                rows += (long)page.getPositionCount();
                pages.add((Object)new RowIterable(this.session.toConnectorSession(), this.types, page));
            }
            if (rows > 0L) {
                data = Iterables.concat((Iterable)pages.build());
            }
        }
        catch (Throwable cause) {
            this.queryManager.failQuery(this.queryId, cause);
        }
        QueryInfo queryInfo = this.queryManager.getQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)((List)iterator.next()).get(0)) != null) {
            this.updateCount = number.longValue();
        }
        if (queryInfo.getState().isDone()) {
            if (queryInfo.getState() == QueryState.FAILED) {
                this.exchangeClient.close();
            } else if (!queryInfo.getOutputStage().isPresent()) {
                this.exchangeClient.close();
                this.columns = ImmutableList.of((Object)new Column("result", "boolean", new ClientTypeSignature("boolean", (List)ImmutableList.of())));
                data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
            }
        }
        URI nextResultsUri = null;
        if (!queryInfo.isFinalQueryInfo() || !this.exchangeClient.isClosed()) {
            nextResultsUri = this.createNextResultsUri(uriInfo);
        }
        this.setCatalog = queryInfo.getSetCatalog();
        this.setSchema = queryInfo.getSetSchema();
        this.setSessionProperties = queryInfo.getSetSessionProperties();
        this.resetSessionProperties = queryInfo.getResetSessionProperties();
        this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.getStartedTransactionId();
        this.clearTransactionId = queryInfo.isClearTransactionId();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), uriInfo.getRequestUriBuilder().replaceQuery(this.queryId.toString()).replacePath("query.html").build(new Object[0]), Query.findCancelableLeafStage(queryInfo), nextResultsUri, this.columns, data, Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo), queryInfo.getUpdateType(), this.updateCount);
        this.lastResultPath = this.lastResult != null && this.lastResult.getNextUri() != null ? this.lastResult.getNextUri().getPath() : null;
        this.lastResult = queryResults;
        return queryResults;
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                String name = columnNames.get(i);
                TypeSignature typeSignature = columnTypes.get(i).getTypeSignature();
                String type = typeSignature.toString();
                list.add((Object)new Column(name, type, new ClientTypeSignature(typeSignature)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        for (URI outputLocation : outputInfo.getBufferLocations()) {
            this.exchangeClient.addLocation(outputLocation);
        }
        if (outputInfo.isNoMoreBufferLocations()) {
            this.exchangeClient.noMoreLocations();
        }
    }

    private ListenableFuture<?> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateFuture(null);
        }
        return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture);
    }

    private synchronized URI createNextResultsUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath("/v1/statement").path(this.queryId.toString()).path(String.valueOf(this.resultId.incrementAndGet())).replaceQuery("").build(new Object[0]);
    }

    private static StatementStats toStatementStats(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
        return StatementStats.builder().setState(queryInfo.getState().toString()).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(outputStage).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setUserTimeMillis(queryStats.getTotalUserTime().toMillis()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setPeakMemoryBytes(queryStats.getPeakUserMemoryReservation().toBytes()).setRootStage(Query.toStageStats(outputStage)).build();
    }

    private static StageStats toStageStats(StageInfo stageInfo) {
        if (stageInfo == null) {
            return null;
        }
        com.facebook.presto.execution.StageStats stageStats = stageInfo.getStageStats();
        ImmutableList.Builder subStages = ImmutableList.builder();
        for (StageInfo subStage : stageInfo.getSubStages()) {
            subStages.add((Object)Query.toStageStats(subStage));
        }
        HashSet<String> uniqueNodes = new HashSet<String>();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            uniqueNodes.add(uri.getHost() + ":" + uri.getPort());
        }
        return StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(stageInfo.getState().toString()).setDone(stageInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageStats.getTotalDrivers()).setQueuedSplits(stageStats.getQueuedDrivers()).setRunningSplits(stageStats.getRunningDrivers() + stageStats.getBlockedDrivers()).setCompletedSplits(stageStats.getCompletedDrivers()).setUserTimeMillis(stageStats.getTotalUserTime().toMillis()).setCpuTimeMillis(stageStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageStats.getRawInputPositions()).setProcessedBytes(stageStats.getRawInputDataSize().toBytes()).setSubStages((List)subStages.build()).build();
    }

    private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
        if (stageInfo == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
        }
        for (StageInfo subStage : stageInfo.getSubStages()) {
            nodes.addAll(Query.globalUniqueNodes(subStage));
        }
        return nodes.build();
    }

    private static URI findCancelableLeafStage(QueryInfo queryInfo) {
        return queryInfo.getOutputStage().map(Query::findCancelableLeafStage).orElse(null);
    }

    private static URI findCancelableLeafStage(StageInfo stage) {
        if (stage.getState().isDone()) {
            return null;
        }
        for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
            URI leafStage = Query.findCancelableLeafStage(subStage);
            if (leafStage == null) continue;
            return leafStage;
        }
        return stage.getSelf();
    }

    private static QueryError toQueryError(QueryInfo queryInfo) {
        ErrorCode errorCode;
        FailureInfo failure = queryInfo.getFailureInfo();
        if (failure == null) {
            QueryState state = queryInfo.getState();
            if (!state.isDone() || state == QueryState.FINISHED) {
                return null;
            }
            log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
            failure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state}))).toFailureInfo();
        }
        if (queryInfo.getErrorCode() != null) {
            errorCode = queryInfo.getErrorCode();
        } else {
            errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
            log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
        }
        return new QueryError(failure.getMessage(), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
    }
}

