/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public final class HttpRequestSessionContext
implements SessionContext {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private final String catalog;
    private final String schema;
    private final Identity identity;
    private final String source;
    private final String userAgent;
    private final String remoteUserAddress;
    private final String timeZoneId;
    private final String language;
    private final Set<String> clientTags;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Map<String, String> preparedStatements;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String clientInfo;

    public HttpRequestSessionContext(HttpServletRequest servletRequest) throws WebApplicationException {
        this.catalog = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-Catalog"));
        this.schema = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-Schema"));
        HttpRequestSessionContext.assertRequest(this.catalog != null || this.schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-User"));
        HttpRequestSessionContext.assertRequest(user != null, "User must be set", new Object[0]);
        this.identity = new Identity(user, Optional.ofNullable(servletRequest.getUserPrincipal()));
        this.source = servletRequest.getHeader("X-Presto-Source");
        this.userAgent = servletRequest.getHeader("User-Agent");
        this.remoteUserAddress = servletRequest.getRemoteAddr();
        this.timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        this.language = servletRequest.getHeader("X-Presto-Language");
        this.clientInfo = servletRequest.getHeader("X-Presto-Client-Info");
        this.clientTags = this.parseClientTags(servletRequest);
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashMap<String, Map> catalogSessionProperties = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry2 : HttpRequestSessionContext.parseSessionHeaders(servletRequest).entrySet()) {
            String fullPropertyName = entry2.getKey();
            String propertyValue = entry2.getValue();
            List nameParts = DOT_SPLITTER.splitToList((CharSequence)fullPropertyName);
            if (nameParts.size() == 1) {
                String propertyName = (String)nameParts.get(0);
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                systemProperties.put((Object)propertyName, (Object)propertyValue);
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.get(0);
                String propertyName = (String)nameParts.get(1);
                HttpRequestSessionContext.assertRequest(!catalogName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
                continue;
            }
            throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        this.systemProperties = systemProperties.build();
        this.catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.preparedStatements = HttpRequestSessionContext.parsePreparedStatementsHeaders(servletRequest);
        String transactionIdHeader = servletRequest.getHeader("X-Presto-Transaction-Id");
        this.clientTransactionSupport = transactionIdHeader != null;
        this.transactionId = HttpRequestSessionContext.parseTransactionId(transactionIdHeader);
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    @Override
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    @Override
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @Override
    public boolean supportClientTransaction() {
        return this.clientTransactionSupport;
    }

    private static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(HttpServletRequest servletRequest) {
        HashMap<String, String> sessionProperties = new HashMap<String, String>();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders("X-Presto-Session"))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session");
            sessionProperties.put((String)nameValue.get(0), (String)nameValue.get(1));
        }
        return sessionProperties;
    }

    private Set<String> parseClientTags(HttpServletRequest servletRequest) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)servletRequest.getHeader("X-Presto-Client-Tags"))));
    }

    private static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw HttpRequestSessionContext.badRequest(String.format(format, args));
        }
    }

    private static Map<String, String> parsePreparedStatementsHeaders(HttpServletRequest servletRequest) {
        ImmutableMap.Builder preparedStatements = ImmutableMap.builder();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders("X-Presto-Prepared-Statement"))) {
            String sqlString;
            String statementName;
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Prepared-Statement");
            try {
                statementName = HttpRequestSessionContext.urlDecode((String)nameValue.get(0));
                sqlString = HttpRequestSessionContext.urlDecode((String)nameValue.get(1));
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            SqlParser sqlParser = new SqlParser();
            try {
                sqlParser.createStatement(sqlString, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE));
            }
            catch (ParsingException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            preparedStatements.put((Object)statementName, (Object)sqlString);
        }
        return preparedStatements.build();
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = HttpRequestSessionContext.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw HttpRequestSessionContext.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

