/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Set;

public class DenyAllAccessControl
implements AccessControl {
    @Override
    public void checkCanSetUser(Principal principal, String userName) {
        AccessDeniedException.denySetUser((Principal)principal, (String)userName);
    }

    @Override
    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAccessCatalog(Identity identity, String catalogName) {
        AccessDeniedException.denyCatalogAccess((String)catalogName);
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        AccessDeniedException.denyCreateSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        AccessDeniedException.denyDropSchema((String)schemaName.toString());
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    @Override
    public void checkCanShowTablesMetadata(TransactionId transactionId, Identity identity, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTablesMetadata((String)schema.toString());
    }

    @Override
    public Set<SchemaTableName> filterTables(TransactionId transactionId, Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanShowSchemas(TransactionId transactionId, Identity identity, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    @Override
    public Set<String> filterSchemas(TransactionId transactionId, Identity identity, String catalogName, Set<String> schemaNames) {
        return ImmutableSet.of();
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    @Override
    public void checkCanDropColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    @Override
    public void checkCanSelectFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denySelectTable((String)tableName.toString());
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    @Override
    public void checkCanSelectFromView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        AccessDeniedException.denySelectView((String)viewName.toString());
    }

    @Override
    public void checkCanCreateViewWithSelectFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString());
    }

    @Override
    public void checkCanCreateViewWithSelectFromView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        AccessDeniedException.denyCreateViewWithSelect((String)viewName.toString());
    }

    @Override
    public void checkCanGrantTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName, String grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanRevokeTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName, String revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
    }
}

