/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@ScalarFunction(value="array_remove")
@Description(value="Remove specified values from the given array")
public final class ArrayRemoveFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayRemoveFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") long value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") double value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") boolean value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") Object value) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i);
            try {
                if (element != null && equalsFunction.invoke(element, value)) continue;
                positions.add(i);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (array.getPositionCount() == positions.size()) {
            return array;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            type.appendTo(array, position, blockBuilder);
        }
        this.pageBuilder.declarePositions(positions.size());
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - positions.size(), positions.size());
    }
}

