/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.array.ReferenceCountMap;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.DictionaryAwarePageFilter;
import com.facebook.presto.operator.project.DictionaryAwarePageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.LazyBlock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PageProcessor {
    static final int MAX_BATCH_SIZE = 8192;
    static final int MAX_PAGE_SIZE_IN_BYTES = 0x400000;
    static final int MIN_PAGE_SIZE_IN_BYTES = 0x100000;
    private final DictionarySourceIdFunction dictionarySourceIdFunction = new DictionarySourceIdFunction();
    private final Optional<PageFilter> filter;
    private final List<PageProjection> projections;
    private int projectBatchSize = 8192;

    public PageProcessor(Optional<PageFilter> filter, List<? extends PageProjection> projections) {
        this.filter = Objects.requireNonNull(filter, "filter is null").map(pageFilter -> {
            if (pageFilter.getInputChannels().size() == 1 && pageFilter.isDeterministic()) {
                return new DictionaryAwarePageFilter((PageFilter)pageFilter);
            }
            return pageFilter;
        });
        this.projections = (List)Objects.requireNonNull(projections, "projections is null").stream().map(projection -> {
            if (projection.getInputChannels().size() == 1 && projection.isDeterministic()) {
                return new DictionaryAwarePageProjection((PageProjection)projection, this.dictionarySourceIdFunction);
            }
            return projection;
        }).collect(ImmutableList.toImmutableList());
    }

    public PageProcessorOutput process(ConnectorSession session, DriverYieldSignal yieldSignal, Page page) {
        this.dictionarySourceIdFunction.reset();
        if (page.getPositionCount() == 0) {
            return PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
        }
        if (this.filter.isPresent()) {
            SelectedPositions selectedPositions = this.filter.get().filter(session, this.filter.get().getInputChannels().getInputChannels(page));
            if (selectedPositions.isEmpty()) {
                return PageProcessorOutput.EMPTY_PAGE_PROCESSOR_OUTPUT;
            }
            if (this.projections.isEmpty()) {
                return new PageProcessorOutput(() -> PageProcessor.calculateRetainedSizeWithoutLoading(page), (Iterator<Optional<Page>>)Iterators.singletonIterator(Optional.of(new Page(selectedPositions.size(), new Block[0]))));
            }
            if (selectedPositions.size() != page.getPositionCount()) {
                PositionsPageProcessorIterator pages = new PositionsPageProcessorIterator(session, yieldSignal, page, selectedPositions);
                return new PageProcessorOutput(pages::getRetainedSizeInBytes, (Iterator<Optional<Page>>)((Object)pages));
            }
        }
        PositionsPageProcessorIterator pages = new PositionsPageProcessorIterator(session, yieldSignal, page, SelectedPositions.positionsRange(0, page.getPositionCount()));
        return new PageProcessorOutput(pages::getRetainedSizeInBytes, (Iterator<Optional<Page>>)((Object)pages));
    }

    @VisibleForTesting
    public List<PageProjection> getProjections() {
        return this.projections;
    }

    private static boolean isUnloadedLazyBlock(Block block) {
        return block instanceof LazyBlock && !((LazyBlock)block).isLoaded();
    }

    private static long calculateRetainedSizeWithoutLoading(Page page) {
        long retainedSizeInBytes = 0L;
        for (Block block : page.getBlocks()) {
            if (PageProcessor.isUnloadedLazyBlock(block)) continue;
            retainedSizeInBytes += block.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    private static class ProcessBatchResult {
        private final ProcessBatchState state;
        private final Page page;

        private ProcessBatchResult(ProcessBatchState state, Page page) {
            this.state = state;
            this.page = page;
        }

        public static ProcessBatchResult processBatchYield() {
            return new ProcessBatchResult(ProcessBatchState.YIELD, null);
        }

        public static ProcessBatchResult processBatchTooLarge() {
            return new ProcessBatchResult(ProcessBatchState.PAGE_TOO_LARGE, null);
        }

        public static ProcessBatchResult processBatchSuccess(Page page) {
            return new ProcessBatchResult(ProcessBatchState.SUCCESS, Objects.requireNonNull(page));
        }

        public boolean isYieldFinish() {
            return this.state == ProcessBatchState.YIELD;
        }

        public boolean isPageTooLarge() {
            return this.state == ProcessBatchState.PAGE_TOO_LARGE;
        }

        public boolean isSuccess() {
            return this.state == ProcessBatchState.SUCCESS;
        }

        public Page getPage() {
            Verify.verify((this.page != null ? 1 : 0) != 0);
            Verify.verify((this.state == ProcessBatchState.SUCCESS ? 1 : 0) != 0);
            return this.page;
        }

        private static enum ProcessBatchState {
            YIELD,
            PAGE_TOO_LARGE,
            SUCCESS;

        }
    }

    @NotThreadSafe
    private static class DictionarySourceIdFunction
    implements Function<DictionaryBlock, DictionaryId> {
        private final Map<DictionaryId, DictionaryId> dictionarySourceIds = new HashMap<DictionaryId, DictionaryId>();

        private DictionarySourceIdFunction() {
        }

        @Override
        public DictionaryId apply(DictionaryBlock block) {
            return this.dictionarySourceIds.computeIfAbsent(block.getDictionarySourceId(), ignored -> DictionaryId.randomDictionaryId());
        }

        public void reset() {
            this.dictionarySourceIds.clear();
        }
    }

    private class PositionsPageProcessorIterator
    extends AbstractIterator<Optional<Page>> {
        private final ConnectorSession session;
        private final DriverYieldSignal yieldSignal;
        private final Page page;
        private SelectedPositions selectedPositions;
        private final Block[] previouslyComputedResults;
        private long retainedSizeInBytes;
        private boolean lastComputeYielded;
        private int lastComputeBatchSize;
        private Work<Block> pageProjectWork;

        public PositionsPageProcessorIterator(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.session = session;
            this.yieldSignal = yieldSignal;
            this.page = page;
            this.selectedPositions = selectedPositions;
            this.previouslyComputedResults = new Block[PageProcessor.this.projections.size()];
            this.updateRetainedSize();
        }

        public long getRetainedSizeInBytes() {
            return this.retainedSizeInBytes;
        }

        protected Optional<Page> computeNext() {
            ProcessBatchResult result;
            int batchSize;
            while (true) {
                if (this.selectedPositions.isEmpty()) {
                    this.updateRetainedSize();
                    Verify.verify((!this.lastComputeYielded ? 1 : 0) != 0);
                    return (Optional)this.endOfData();
                }
                if (this.lastComputeYielded) {
                    Verify.verify((this.lastComputeBatchSize > 0 ? 1 : 0) != 0);
                    batchSize = this.lastComputeBatchSize;
                    this.lastComputeYielded = false;
                    this.lastComputeBatchSize = 0;
                } else {
                    batchSize = Math.min(this.selectedPositions.size(), PageProcessor.this.projectBatchSize);
                }
                result = this.processBatch(batchSize);
                if (result.isYieldFinish()) {
                    this.lastComputeYielded = true;
                    this.lastComputeBatchSize = batchSize;
                    return Optional.empty();
                }
                if (!result.isPageTooLarge()) break;
                Verify.verify((batchSize > 1 ? 1 : 0) != 0);
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            Verify.verify((boolean)result.isSuccess());
            Page page = result.getPage();
            long pageSize = page.getSizeInBytes();
            if (page.getPositionCount() > 1 && pageSize > 0x400000L) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize / 2;
            }
            if (pageSize < 0x100000L && PageProcessor.this.projectBatchSize < 8192) {
                PageProcessor.this.projectBatchSize = PageProcessor.this.projectBatchSize * 2;
            }
            this.selectedPositions = this.selectedPositions.subRange(batchSize, this.selectedPositions.size());
            for (int i = 0; i < this.previouslyComputedResults.length; ++i) {
                this.previouslyComputedResults[i] = this.previouslyComputedResults[i] != null && this.previouslyComputedResults[i].getPositionCount() > batchSize ? this.previouslyComputedResults[i].getRegion(batchSize, this.previouslyComputedResults[i].getPositionCount() - batchSize) : null;
            }
            this.updateRetainedSize();
            return Optional.of(page);
        }

        private void updateRetainedSize() {
            this.retainedSizeInBytes = 0L;
            ReferenceCountMap referenceCountMap = new ReferenceCountMap();
            for (Block block : this.page.getBlocks()) {
                if (PageProcessor.isUnloadedLazyBlock(block)) continue;
                block.retainedBytesForEachPart((object, size) -> {
                    if (referenceCountMap.incrementAndGet(object) == 1) {
                        this.retainedSizeInBytes += size.longValue();
                    }
                });
            }
            for (Block previouslyComputedResult : this.previouslyComputedResults) {
                if (previouslyComputedResult == null) continue;
                previouslyComputedResult.retainedBytesForEachPart((object, size) -> {
                    if (referenceCountMap.incrementAndGet(object) == 1) {
                        this.retainedSizeInBytes += size.longValue();
                    }
                });
            }
        }

        private ProcessBatchResult processBatch(int batchSize) {
            Block[] blocks = new Block[PageProcessor.this.projections.size()];
            int pageSize = 0;
            SelectedPositions positionsBatch = this.selectedPositions.subRange(0, batchSize);
            for (int i = 0; i < PageProcessor.this.projections.size(); ++i) {
                if (this.yieldSignal.isSet()) {
                    return ProcessBatchResult.processBatchYield();
                }
                if (positionsBatch.size() > 1 && pageSize > 0x400000) {
                    return ProcessBatchResult.processBatchTooLarge();
                }
                PageProjection projection = (PageProjection)PageProcessor.this.projections.get(i);
                if (this.previouslyComputedResults[i] != null && this.previouslyComputedResults[i].getPositionCount() >= batchSize) {
                    blocks[i] = this.previouslyComputedResults[i].getRegion(0, batchSize);
                } else {
                    if (this.pageProjectWork == null) {
                        this.pageProjectWork = projection.project(this.session, this.yieldSignal, projection.getInputChannels().getInputChannels(this.page), positionsBatch);
                    }
                    if (!this.pageProjectWork.process()) {
                        return ProcessBatchResult.processBatchYield();
                    }
                    this.previouslyComputedResults[i] = this.pageProjectWork.getResult();
                    this.pageProjectWork = null;
                    blocks[i] = this.previouslyComputedResults[i];
                }
                pageSize = (int)((long)pageSize + blocks[i].getSizeInBytes());
            }
            return ProcessBatchResult.processBatchSuccess(new Page(positionsBatch.size(), blocks));
        }
    }
}

