/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.index.TuplePageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DynamicTupleFilterFactory {
    private final int filterOperatorId;
    private final PlanNodeId planNodeId;
    private final int[] tupleFilterChannels;
    private final List<Integer> outputFilterChannels;
    private final List<Type> filterTypes;
    private final List<Type> outputTypes;
    private final List<Supplier<PageProjection>> outputProjections;

    public DynamicTupleFilterFactory(int filterOperatorId, PlanNodeId planNodeId, int[] tupleFilterChannels, int[] outputFilterChannels, List<Type> outputTypes, PageFunctionCompiler pageFunctionCompiler) {
        Objects.requireNonNull(planNodeId, "planNodeId is null");
        Objects.requireNonNull(tupleFilterChannels, "tupleFilterChannels is null");
        Preconditions.checkArgument((tupleFilterChannels.length > 0 ? 1 : 0) != 0, (Object)"Must have at least one tupleFilterChannel");
        Objects.requireNonNull(outputFilterChannels, "outputFilterChannels is null");
        Preconditions.checkArgument((outputFilterChannels.length == tupleFilterChannels.length ? 1 : 0) != 0, (Object)"outputFilterChannels must have same length as tupleFilterChannels");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Preconditions.checkArgument((outputTypes.size() >= outputFilterChannels.length ? 1 : 0) != 0, (Object)"Must have at least as many output channels as those used for filtering");
        Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.filterOperatorId = filterOperatorId;
        this.planNodeId = planNodeId;
        this.tupleFilterChannels = (int[])tupleFilterChannels.clone();
        this.outputFilterChannels = ImmutableList.copyOf((Collection)Ints.asList((int[])outputFilterChannels));
        this.filterTypes = (List)IntStream.of(outputFilterChannels).mapToObj(outputTypes::get).collect(ImmutableList.toImmutableList());
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.outputProjections = (List)IntStream.range(0, outputTypes.size()).mapToObj(field -> pageFunctionCompiler.compileProjection(Expressions.field(field, (Type)outputTypes.get(field)), Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public OperatorFactory filterWithTuple(Page tuplePage) {
        Page filterTuple = this.getFilterTuple(tuplePage);
        Supplier<PageProcessor> processor = this.createPageProcessor(filterTuple);
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(this.filterOperatorId, this.planNodeId, processor, this.outputTypes, new DataSize(0.0, DataSize.Unit.BYTE), 0);
    }

    @VisibleForTesting
    public Supplier<PageProcessor> createPageProcessor(Page filterTuple) {
        TuplePageFilter filter = new TuplePageFilter(filterTuple, this.filterTypes, this.outputFilterChannels);
        return () -> new PageProcessor(Optional.of(filter), (List)this.outputProjections.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()));
    }

    private Page getFilterTuple(Page tuplePage) {
        Block[] normalizedBlocks = new Block[this.tupleFilterChannels.length];
        for (int i = 0; i < this.tupleFilterChannels.length; ++i) {
            normalizedBlocks[i] = tuplePage.getBlock(this.tupleFilterChannels[i]);
        }
        return new Page(normalizedBlocks);
    }
}

