/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final LocalPartitionGenerator partitionGenerator;
    private final IntArrayList[] partitionAssignments;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, List<? extends Type> types, List<Integer> partitionChannels, Optional<Integer> hashChannel) {
        HashGenerator hashGenerator;
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        if (hashChannel.isPresent()) {
            hashGenerator = new PrecomputedHashGenerator(hashChannel.get());
        } else {
            List partitionChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            hashGenerator = new InterpretedHashGenerator((List<Type>)partitionChannelTypes, Ints.toArray(partitionChannels));
        }
        this.partitionGenerator = new LocalPartitionGenerator(hashGenerator, this.buffers.size());
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        for (IntArrayList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int partition = this.partitionGenerator.getPartition(page, position);
            this.partitionAssignments[partition].add(position);
        }
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length];
        for (int partition = 0; partition < this.buffers.size(); ++partition) {
            IntArrayList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            for (int i = 0; i < sourceBlocks.length; ++i) {
                outputBlocks[i] = sourceBlocks[i].copyPositions(positions.elements(), 0, positions.size());
            }
            Page pageSplit = new Page(positions.size(), outputBlocks);
            this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes())));
        }
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

