/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.exchange.LocalExchangeBufferInfo;
import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchangeSource {
    private static final SettableFuture<?> NOT_EMPTY = SettableFuture.create();
    private final List<Type> types;
    private final Consumer<LocalExchangeSource> onFinish;
    private final BlockingQueue<PageReference> buffer = new LinkedBlockingDeque<PageReference>();
    private final AtomicLong bufferedBytes = new AtomicLong();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private SettableFuture<?> notEmptyFuture = NOT_EMPTY;
    @GuardedBy(value="lock")
    private boolean finishing;

    public LocalExchangeSource(List<? extends Type> types, Consumer<LocalExchangeSource> onFinish) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.onFinish = Objects.requireNonNull(onFinish, "onFinish is null");
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public LocalExchangeBufferInfo getBufferInfo() {
        return new LocalExchangeBufferInfo(this.bufferedBytes.get(), this.buffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPage(PageReference pageReference) {
        SettableFuture<?> notEmptyFuture;
        this.checkNotHoldsLock();
        boolean added = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.finishing) {
                this.bufferedBytes.addAndGet(pageReference.getRetainedSizeInBytes());
                this.buffer.add(pageReference);
                added = true;
            }
            notEmptyFuture = this.notEmptyFuture;
            this.notEmptyFuture = NOT_EMPTY;
        }
        if (!added) {
            pageReference.removePage();
        }
        notEmptyFuture.set(null);
    }

    public Page removePage() {
        this.checkNotHoldsLock();
        PageReference pageReference = (PageReference)this.buffer.poll();
        if (pageReference == null) {
            return null;
        }
        Page page = pageReference.removePage();
        this.bufferedBytes.addAndGet(-page.getRetainedSizeInBytes());
        this.checkFinished();
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> waitForReading() {
        this.checkNotHoldsLock();
        Object object = this.lock;
        synchronized (object) {
            if (!this.finishing && this.buffer.isEmpty() && this.notEmptyFuture.isDone()) {
                this.notEmptyFuture = SettableFuture.create();
            }
            return this.notEmptyFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.finishing && this.buffer.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        SettableFuture<?> notEmptyFuture;
        this.checkNotHoldsLock();
        Object object = this.lock;
        synchronized (object) {
            if (this.finishing) {
                return;
            }
            this.finishing = true;
            notEmptyFuture = this.notEmptyFuture;
            this.notEmptyFuture = NOT_EMPTY;
        }
        notEmptyFuture.set(null);
        this.checkFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SettableFuture<?> notEmptyFuture;
        this.checkNotHoldsLock();
        ArrayList remainingPages = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            this.finishing = true;
            this.buffer.drainTo(remainingPages);
            this.bufferedBytes.addAndGet(-remainingPages.stream().mapToLong(PageReference::getRetainedSizeInBytes).sum());
            notEmptyFuture = this.notEmptyFuture;
            this.notEmptyFuture = NOT_EMPTY;
        }
        remainingPages.forEach(PageReference::removePage);
        notEmptyFuture.set(null);
        Preconditions.checkState((boolean)this.isFinished(), (Object)"Expected buffer to be finished");
        this.checkFinished();
    }

    private void checkFinished() {
        this.checkNotHoldsLock();
        if (this.isFinished()) {
            this.onFinish.accept(this);
        }
    }

    private void checkNotHoldsLock() {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not execute this method while holding the lock");
    }

    static {
        NOT_EMPTY.set(null);
    }
}

