/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LocalPlannerAware;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class LocalExchangeSinkOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalExchangeSink sink;
    private final Function<Page, Page> pagePreprocessor;

    LocalExchangeSinkOperator(OperatorContext operatorContext, LocalExchangeSink sink, Function<Page, Page> pagePreprocessor) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sink = Objects.requireNonNull(sink, "sink is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.sink.getTypes();
    }

    @Override
    public void finish() {
        this.sink.finish();
    }

    @Override
    public boolean isFinished() {
        return this.sink.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.sink.waitForWriting();
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        page = this.pagePreprocessor.apply(page);
        this.sink.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.finish();
    }

    public static class LocalExchangeSinkOperatorFactory
    implements OperatorFactory,
    LocalPlannerAware {
        private final LocalExchange.LocalExchangeFactory localExchangeFactory;
        private final int operatorId;
        private final LocalExchange.LocalExchangeSinkFactoryId sinkFactoryId;
        private final PlanNodeId planNodeId;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public LocalExchangeSinkOperatorFactory(LocalExchange.LocalExchangeFactory localExchangeFactory, int operatorId, PlanNodeId planNodeId, LocalExchange.LocalExchangeSinkFactoryId sinkFactoryId, Function<Page, Page> pagePreprocessor) {
            this.localExchangeFactory = Objects.requireNonNull(localExchangeFactory, "localExchangeFactory is null");
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sinkFactoryId = Objects.requireNonNull(sinkFactoryId, "sinkFactoryId is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public List<Type> getTypes() {
            return this.localExchangeFactory.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalExchangeSinkOperator.class.getSimpleName());
            LocalExchange.LocalExchangeSinkFactory localExchangeSinkFactory = this.localExchangeFactory.getLocalExchange(driverContext.getLifespan()).getSinkFactory(this.sinkFactoryId);
            return new LocalExchangeSinkOperator(operatorContext, localExchangeSinkFactory.createSink(), this.pagePreprocessor);
        }

        @Override
        public void noMoreOperators() {
            if (!this.closed) {
                this.closed = true;
                this.localExchangeFactory.closeSinks(this.sinkFactoryId);
            }
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.localExchangeFactory.getLocalExchange(lifespan).getSinkFactory(this.sinkFactoryId).close();
        }

        @Override
        public OperatorFactory duplicate() {
            return new LocalExchangeSinkOperatorFactory(this.localExchangeFactory, this.operatorId, this.planNodeId, this.localExchangeFactory.newSinkFactoryId(), this.pagePreprocessor);
        }

        @Override
        public void localPlannerComplete() {
            this.localExchangeFactory.noMoreSinkFactories();
        }
    }
}

