/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class LocalExchangeSink {
    private final List<Type> types;
    private final LocalExchanger exchanger;
    private final Consumer<LocalExchangeSink> onFinish;
    private final AtomicBoolean finished = new AtomicBoolean();

    public static LocalExchangeSink finishedLocalExchangeSink(List<Type> types) {
        LocalExchangeSink finishedSink = new LocalExchangeSink(types, LocalExchanger.FINISHED, sink -> {});
        finishedSink.finish();
        return finishedSink;
    }

    public LocalExchangeSink(List<Type> types, LocalExchanger exchanger, Consumer<LocalExchangeSink> onFinish) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.exchanger = Objects.requireNonNull(exchanger, "exchanger is null");
        this.onFinish = Objects.requireNonNull(onFinish, "onFinish is null");
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void finish() {
        if (this.finished.compareAndSet(false, true)) {
            this.onFinish.accept(this);
        }
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void addPage(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (this.isFinished()) {
            return;
        }
        Preconditions.checkArgument((page.getChannelCount() == this.getTypes().size() ? 1 : 0) != 0);
        this.exchanger.accept(page);
    }

    public ListenableFuture<?> waitForWriting() {
        if (this.isFinished()) {
            return Operator.NOT_BLOCKED;
        }
        return this.exchanger.waitForWriting();
    }
}

