/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.ArrayAggregationState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.Type;

public class ArrayAggregationStateSerializer
implements AccumulatorStateSerializer<ArrayAggregationState> {
    private final Type elementType;
    private final Type arrayType;

    public ArrayAggregationStateSerializer(Type elementType) {
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(ArrayAggregationState state, BlockBuilder out) {
        if (state.getBlockBuilder() == null) {
            out.appendNull();
        } else {
            Block stateBlock = state.getBlockBuilder().build();
            this.arrayType.writeObject(out, (Object)stateBlock);
        }
    }

    public void deserialize(Block block, int index, ArrayAggregationState state) {
        Block stateBlock = (Block)this.arrayType.getObject(block, index);
        int positionCount = stateBlock.getPositionCount();
        BlockBuilder blockBuilder = this.elementType.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            this.elementType.appendTo(stateBlock, i, blockBuilder);
        }
        state.setBlockBuilder(blockBuilder);
    }
}

