/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.histogram;

import com.facebook.presto.operator.aggregation.histogram.HistogramState;
import com.facebook.presto.operator.aggregation.histogram.SingleTypedHistogram;
import com.facebook.presto.operator.aggregation.histogram.TypedHistogram;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import org.openjdk.jol.info.ClassLayout;

public class SingleHistogramState
implements HistogramState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleHistogramState.class).instanceSize();
    private SingleTypedHistogram typedHistogram;

    public SingleHistogramState(Type keyType, int expectedEntriesCount) {
        this.typedHistogram = new SingleTypedHistogram(keyType, expectedEntriesCount);
    }

    @Override
    public TypedHistogram get() {
        return this.typedHistogram;
    }

    @Override
    public void set(TypedHistogram value) {
        Preconditions.checkArgument((boolean)(value instanceof SingleTypedHistogram), (String)"set must be called with class type % only. Received %s", this.getClass(), value.getClass());
        this.typedHistogram = (SingleTypedHistogram)value;
    }

    @Override
    public void deserialize(Block block, Type type, int expectedSize) {
        this.typedHistogram = new SingleTypedHistogram(block, type, expectedSize);
    }

    @Override
    public void addMemoryUsage(long memory) {
    }

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.typedHistogram != null) {
            estimatedSize += this.typedHistogram.getEstimatedSize();
        }
        return estimatedSize;
    }
}

