/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.histogram;

import com.facebook.presto.operator.aggregation.histogram.GroupedTypedHistogram;
import com.facebook.presto.operator.aggregation.histogram.HistogramState;
import com.facebook.presto.operator.aggregation.histogram.TypedHistogram;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedHistogramState
extends AbstractGroupedAccumulatorState
implements HistogramState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedHistogramState.class).instanceSize();
    private TypedHistogram typedHistogram;
    private long size;

    public GroupedHistogramState(Type keyType, int expectedEntriesCount) {
        this.typedHistogram = new GroupedTypedHistogram(keyType, expectedEntriesCount);
    }

    public void ensureCapacity(long size) {
        this.typedHistogram.ensureCapacity(size);
    }

    @Override
    public TypedHistogram get() {
        return this.typedHistogram.setGroupId(this.getGroupId());
    }

    @Override
    public void set(TypedHistogram value) {
        Preconditions.checkArgument((boolean)(value instanceof GroupedTypedHistogram), (String)"only class %s supported, passed %s", GroupedTypedHistogram.class, this.typedHistogram.getClass());
        Objects.requireNonNull(Boolean.valueOf(this.typedHistogram != null), "this.typedHistogram should always be non-null");
        this.size -= this.typedHistogram.getEstimatedSize();
        this.size += value.getEstimatedSize();
        this.typedHistogram = value;
    }

    @Override
    public void deserialize(Block block, Type type, int expectedSize) {
        this.typedHistogram = new GroupedTypedHistogram(this.getGroupId(), block, type, expectedSize);
    }

    @Override
    public void addMemoryUsage(long memory) {
        this.size += memory;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.size + this.typedHistogram.getEstimatedSize();
    }
}

