/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.ParametricFunctionHelpers;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.aggregation.AggregationHeader;
import com.facebook.presto.operator.aggregation.AggregationImplementation;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LazyAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class ParametricAggregation
extends SqlAggregationFunction {
    AggregationHeader details;
    ParametricImplementationsGroup<AggregationImplementation> implementations;

    public ParametricAggregation(Signature signature, AggregationHeader details, ParametricImplementationsGroup implementations) {
        super(signature);
        this.details = details;
        this.implementations = implementations;
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), variables, arity);
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(boundSignature, variables, typeManager, functionRegistry);
        List inputTypes = (List)boundSignature.getArgumentTypes().stream().map(x -> typeManager.getType(x)).collect(ImmutableList.toImmutableList());
        Type outputType = typeManager.getType(boundSignature.getReturnType());
        Class<?> definitionClass = concreteImplementation.getDefinitionClass();
        DynamicClassLoader classLoader = new DynamicClassLoader(definitionClass.getClassLoader(), this.getClass().getClassLoader());
        Class<?> stateClass = concreteImplementation.getStateClass();
        AccumulatorStateSerializer<?> stateSerializer = ParametricAggregation.getAccumulatorStateSerializer(concreteImplementation, variables, typeManager, functionRegistry, stateClass, classLoader);
        AccumulatorStateFactory<?> stateFactory = StateCompiler.generateStateFactory(stateClass, classLoader);
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), variables, typeManager, functionRegistry);
        MethodHandle combineHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getCombineFunction(), concreteImplementation.getCombineDependencies(), variables, typeManager, functionRegistry);
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), variables, typeManager, functionRegistry);
        List<AggregationMetadata.ParameterMetadata> parametersMetadata = ParametricAggregation.buildParameterMetadata(concreteImplementation.getInputParameterMetadataTypes(), inputTypes);
        String aggregationName = AggregationUtils.generateAggregationName(this.getSignature().getName(), outputType.getTypeSignature(), ParametricAggregation.signaturesFromTypes(inputTypes));
        AggregationMetadata metadata = new AggregationMetadata(aggregationName, parametersMetadata, inputHandle, combineHandle, outputHandle, stateClass, stateSerializer, stateFactory, outputType);
        return new InternalAggregationFunction(this.getSignature().getName(), inputTypes, stateSerializer.getSerializedType(), outputType, this.details.isDecomposable(), this.details.isOrderSensitive(), new LazyAccumulatorFactoryBinder(metadata, classLoader));
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public String getDescription() {
        return this.details.getDescription().orElse("");
    }

    private AggregationImplementation findMatchingImplementation(Signature boundSignature, BoundVariables variables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(boundSignature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature, variables, typeManager, functionRegistry)) continue;
                if (foundImplementation.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", variables, this.getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (!foundImplementation.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", variables, this.getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    private static AccumulatorStateSerializer<?> getAccumulatorStateSerializer(AggregationImplementation implementation, BoundVariables variables, TypeManager typeManager, FunctionRegistry functionRegistry, Class<?> stateClass, DynamicClassLoader classLoader) {
        AccumulatorStateSerializer stateSerializer;
        Optional<MethodHandle> stateSerializerFactory = implementation.getStateSerializerFactory();
        if (stateSerializerFactory.isPresent()) {
            try {
                MethodHandle factoryHandle = ParametricFunctionHelpers.bindDependencies(stateSerializerFactory.get(), implementation.getStateSerializerFactoryDependencies(), variables, typeManager, functionRegistry);
                stateSerializer = factoryHandle.invoke();
            }
            catch (Throwable e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            stateSerializer = StateCompiler.generateStateSerializer(stateClass, classLoader);
        }
        return stateSerializer;
    }

    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager) {
        return this.specialize(variables, arity, typeManager, null);
    }

    private static List<TypeSignature> signaturesFromTypes(List<Type> types) {
        return (List)types.stream().map(x -> x.getTypeSignature()).collect(ImmutableList.toImmutableList());
    }

    private static List<AggregationMetadata.ParameterMetadata> buildParameterMetadata(List<AggregationMetadata.ParameterMetadata.ParameterType> parameterMetadataTypes, List<Type> inputTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int inputId = 0;
        for (AggregationMetadata.ParameterMetadata.ParameterType parameterMetadataType : parameterMetadataTypes) {
            switch (parameterMetadataType) {
                case STATE: 
                case BLOCK_INDEX: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType));
                    break;
                }
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType, inputTypes.get(inputId++)));
                }
            }
        }
        return builder.build();
    }
}

