/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.WindowIndex;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericAccumulatorFactory
implements AccumulatorFactory {
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final Optional<Integer> maskChannel;
    private final List<Integer> inputChannels;
    private final List<Type> sourceTypes;
    private final List<Integer> orderByChannels;
    private final List<SortOrder> orderings;
    private final PagesIndex.Factory pagesIndexFactory;

    public GenericAccumulatorFactory(AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Constructor<? extends Accumulator> accumulatorConstructor, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<Integer> inputChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
        this.stateSerializer = Objects.requireNonNull(stateSerializer, "stateSerializer is null");
        this.stateFactory = Objects.requireNonNull(stateFactory, "stateFactory is null");
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.inputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
        this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
        this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        Preconditions.checkArgument((orderByChannels.isEmpty() || !Objects.isNull(pagesIndexFactory) ? 1 : 0) != 0, (Object)"No pagesIndexFactory to process ordering");
        this.pagesIndexFactory = pagesIndexFactory;
    }

    @Override
    public List<Integer> getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Accumulator createAccumulator() {
        Accumulator accumulator;
        try {
            accumulator = this.accumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, this.inputChannels, this.maskChannel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, ImmutableList.of(), Optional.empty());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator() {
        GroupedAccumulator accumulator;
        try {
            accumulator = this.groupedAccumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, this.inputChannels, this.maskChannel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingGroupedAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateSerializer, this.stateFactory, ImmutableList.of(), this.maskChannel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasOrderBy() {
        return !this.orderByChannels.isEmpty();
    }

    private static class OrderingGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;
        private long groupCount;

        private OrderingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            Objects.requireNonNull(aggregationSourceTypes, "aggregationSourceTypes is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            ArrayList<Type> pageIndexTypes = new ArrayList<Type>(aggregationSourceTypes);
            pageIndexTypes.add((Type)BigintType.BIGINT);
            this.pagesIndex = pagesIndexFactory.newPagesIndex(pageIndexTypes, 10000);
            this.groupCount = 0L;
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Block[] blocks = new Block[page.getChannelCount() + 1];
            for (int i = 0; i < page.getChannelCount(); ++i) {
                blocks[i] = page.getBlock(i);
            }
            blocks[page.getChannelCount()] = groupIdsBlock;
            this.groupCount = Long.max(this.groupCount, groupIdsBlock.getGroupCount());
            this.pagesIndex.addPage(new Page(blocks));
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(page -> {
                GroupByIdBlock groupIds = new GroupByIdBlock(this.groupCount, page.getBlock(page.getChannelCount() - 1));
                this.accumulator.addInput(groupIds, (Page)page);
            });
        }
    }

    private static class OrderingAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;

        private OrderingAccumulator(Accumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            this.pagesIndex = pagesIndexFactory.newPagesIndex(aggregationSourceTypes, 10000);
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        @Override
        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInput(Page page) {
            this.pagesIndex.addPage(page);
        }

        @Override
        public void addInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(this.accumulator::addInput);
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }
}

