/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationState;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationStateFactory;
import com.facebook.presto.operator.aggregation.state.ArrayAggregationStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayAggregationFunction
extends SqlAggregationFunction {
    private static final String NAME = "array_agg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "input", Type.class, ArrayAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "combine", Type.class, ArrayAggregationState.class, ArrayAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ArrayAggregationFunction.class, "output", Type.class, ArrayAggregationState.class, BlockBuilder.class);
    private final boolean legacyArrayAgg;

    public ArrayAggregationFunction(boolean legacyArrayAgg) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")));
        this.legacyArrayAgg = legacyArrayAgg;
    }

    @Override
    public String getDescription() {
        return "return an array of values";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = boundVariables.getTypeVariable("T");
        return ArrayAggregationFunction.generateAggregation(type, this.legacyArrayAgg);
    }

    private static InternalAggregationFunction generateAggregation(Type type, boolean legacyArrayAgg) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ArrayAggregationFunction.class.getClassLoader());
        ArrayAggregationStateSerializer stateSerializer = new ArrayAggregationStateSerializer(type);
        ArrayAggregationStateFactory stateFactory = new ArrayAggregationStateFactory();
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        ArrayType outputType = new ArrayType(type);
        Type intermediateType = stateSerializer.getSerializedType();
        List<AggregationMetadata.ParameterMetadata> inputParameterMetadata = ArrayAggregationFunction.createInputParameterMetadata(type, legacyArrayAgg);
        MethodHandle inputFunction = INPUT_FUNCTION.bindTo(type);
        MethodHandle combineFunction = COMBINE_FUNCTION.bindTo(type);
        MethodHandle outputFunction = OUTPUT_FUNCTION.bindTo(outputType);
        Class<ArrayAggregationState> stateInterface = ArrayAggregationState.class;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), inputParameterMetadata, inputFunction, combineFunction, outputFunction, stateInterface, stateSerializer, stateFactory, (Type)outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, (Type)outputType, true, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, boolean legacyArrayAgg) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(legacyArrayAgg ? AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL : AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, ArrayAggregationState state, Block value, int position) {
        BlockBuilder blockBuilder = state.getBlockBuilder();
        if (blockBuilder == null) {
            blockBuilder = type.createBlockBuilder(null, 4);
            state.setBlockBuilder(blockBuilder);
        }
        long startSize = blockBuilder.getRetainedSizeInBytes();
        type.appendTo(value, position, blockBuilder);
        state.addMemoryUsage(blockBuilder.getRetainedSizeInBytes() - startSize);
    }

    public static void combine(Type type, ArrayAggregationState state, ArrayAggregationState otherState) {
        BlockBuilder stateBlockBuilder = state.getBlockBuilder();
        BlockBuilder otherStateBlockBuilder = otherState.getBlockBuilder();
        if (otherStateBlockBuilder == null) {
            return;
        }
        if (stateBlockBuilder == null) {
            state.setBlockBuilder(otherStateBlockBuilder);
            return;
        }
        int otherPositionCount = otherStateBlockBuilder.getPositionCount();
        long startSize = stateBlockBuilder.getRetainedSizeInBytes();
        for (int i = 0; i < otherPositionCount; ++i) {
            type.appendTo((Block)otherStateBlockBuilder, i, stateBlockBuilder);
        }
        state.addMemoryUsage(stateBlockBuilder.getRetainedSizeInBytes() - startSize);
    }

    public static void output(Type outputType, ArrayAggregationState state, BlockBuilder out) {
        BlockBuilder stateBlockBuilder = state.getBlockBuilder();
        if (stateBlockBuilder == null || stateBlockBuilder.getPositionCount() == 0) {
            out.appendNull();
        } else {
            outputType.writeObject(out, (Object)stateBlockBuilder.build());
        }
    }
}

