/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AggregationMetadata {
    public static final Set<Class<?>> SUPPORTED_PARAMETER_TYPES = ImmutableSet.of(Block.class, Long.TYPE, Double.TYPE, Boolean.TYPE, Slice.class);
    private final String name;
    private final List<ParameterMetadata> inputMetadata;
    private final MethodHandle inputFunction;
    private final MethodHandle combineFunction;
    private final MethodHandle outputFunction;
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Type outputType;

    public AggregationMetadata(String name, List<ParameterMetadata> inputMetadata, MethodHandle inputFunction, MethodHandle combineFunction, MethodHandle outputFunction, Class<?> stateInterface, AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Type outputType) {
        this.outputType = Objects.requireNonNull(outputType);
        this.inputMetadata = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputMetadata, "inputMetadata is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction is null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
        this.stateSerializer = Objects.requireNonNull(stateSerializer, "stateSerializer is null");
        this.stateFactory = Objects.requireNonNull(stateFactory, "stateFactory is null");
        AggregationMetadata.verifyInputFunctionSignature(inputFunction, inputMetadata, stateInterface);
        AggregationMetadata.verifyCombineFunction(combineFunction, stateInterface);
        AggregationMetadata.verifyExactOutputFunction(outputFunction, stateInterface);
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<ParameterMetadata> getInputMetadata() {
        return this.inputMetadata;
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public MethodHandle getCombineFunction() {
        return this.combineFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public AccumulatorStateSerializer<?> getStateSerializer() {
        return this.stateSerializer;
    }

    public AccumulatorStateFactory<?> getStateFactory() {
        return this.stateFactory;
    }

    private static void verifyInputFunctionSignature(MethodHandle method, List<ParameterMetadata> parameterMetadatas, Class<?> stateInterface) {
        Class<?>[] parameters = method.type().parameterArray();
        Preconditions.checkArgument((parameters.length > 0 ? 1 : 0) != 0, (Object)"Aggregation input function must have at least one parameter");
        Preconditions.checkArgument((parameterMetadatas.stream().filter(m -> m.getParameterType() == ParameterMetadata.ParameterType.STATE).count() == 1L ? 1 : 0) != 0, (Object)"There must be exactly one state parameter in input function");
        Preconditions.checkArgument((parameterMetadatas.get(0).getParameterType() == ParameterMetadata.ParameterType.STATE ? 1 : 0) != 0, (Object)"First parameter must be state");
        block6: for (int i = 0; i < parameters.length; ++i) {
            ParameterMetadata metadata = parameterMetadatas.get(i);
            switch (metadata.getParameterType()) {
                case STATE: {
                    Preconditions.checkArgument((stateInterface == parameters[i] ? 1 : 0) != 0, (Object)String.format("State argument must be of type %s", stateInterface));
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    Preconditions.checkArgument((parameters[i] == Block.class ? 1 : 0) != 0, (Object)"Parameter must be Block if it has @BlockPosition");
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    Preconditions.checkArgument((boolean)SUPPORTED_PARAMETER_TYPES.contains(parameters[i]), (String)"Unsupported type: %s", (Object)parameters[i].getSimpleName());
                    Preconditions.checkArgument((parameters[i] == metadata.getSqlType().getJavaType() ? 1 : 0) != 0, (String)"Expected method %s parameter %s type to be %s (%s)", (Object)method, (Object)i, (Object)metadata.getSqlType().getJavaType().getName(), (Object)metadata.getSqlType());
                    continue block6;
                }
                case BLOCK_INDEX: {
                    Preconditions.checkArgument((parameters[i] == Integer.TYPE ? 1 : 0) != 0, (Object)"Block index parameter must be an int");
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter: " + (Object)((Object)metadata.getParameterType()));
                }
            }
        }
    }

    private static void verifyCombineFunction(MethodHandle method, Class<?> stateInterface) {
        Class<?>[] parameterTypes = method.type().parameterArray();
        Preconditions.checkArgument((parameterTypes.length == 2 ? 1 : 0) != 0, (Object)"Combine function must take exactly 2 arguments.");
        Preconditions.checkArgument((Arrays.stream(parameterTypes).filter(type -> type.equals(stateInterface)).count() == 2L ? 1 : 0) != 0, (String)"Combine function must take exactly two arguments of type %s annotated as @AggregationState", (Object)stateInterface.getSimpleName());
    }

    private static void verifyExactOutputFunction(MethodHandle method, Class<?> stateInterface) {
        if (method == null) {
            return;
        }
        Class<?>[] parameterTypes = method.type().parameterArray();
        Preconditions.checkArgument((parameterTypes.length == 2 ? 1 : 0) != 0, (Object)"Output function must take at exactly 2 arguments.");
        Preconditions.checkArgument((Arrays.stream(parameterTypes).filter(type -> type.equals(stateInterface)).count() == 1L ? 1 : 0) != 0, (String)"Output function must take exactly one @AggregationState of type %s", (Object)stateInterface.getSimpleName());
        Preconditions.checkArgument((Arrays.stream(parameterTypes).filter(type -> type.equals(BlockBuilder.class)).count() == 1L ? 1 : 0) != 0, (Object)"Output function must take exactly one BlockBuilder parameter");
    }

    public static int countInputChannels(List<ParameterMetadata> metadatas) {
        int parameters = 0;
        for (ParameterMetadata metadata : metadatas) {
            if (metadata.getParameterType() != ParameterMetadata.ParameterType.INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
            ++parameters;
        }
        return parameters;
    }

    public static class ParameterMetadata {
        private final ParameterType parameterType;
        private final Type sqlType;

        public ParameterMetadata(ParameterType parameterType) {
            this(parameterType, null);
        }

        public ParameterMetadata(ParameterType parameterType, Type sqlType) {
            Preconditions.checkArgument((sqlType == null == (parameterType == ParameterType.BLOCK_INDEX || parameterType == ParameterType.STATE) ? 1 : 0) != 0, (Object)"sqlType must be provided only for input channels");
            this.parameterType = parameterType;
            this.sqlType = sqlType;
        }

        public static ParameterMetadata fromSqlType(Type sqlType, boolean isBlock, boolean isNullable, String methodName) {
            return new ParameterMetadata(ParameterType.inputChannelParameterType(isNullable, isBlock, methodName), sqlType);
        }

        public static ParameterMetadata forBlockIndexParameter() {
            return new ParameterMetadata(ParameterType.BLOCK_INDEX);
        }

        public static ParameterMetadata forStateParameter() {
            return new ParameterMetadata(ParameterType.STATE);
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public Type getSqlType() {
            return this.sqlType;
        }

        public static enum ParameterType {
            INPUT_CHANNEL,
            BLOCK_INPUT_CHANNEL,
            NULLABLE_BLOCK_INPUT_CHANNEL,
            BLOCK_INDEX,
            STATE;


            static ParameterType inputChannelParameterType(boolean isNullable, boolean isBlock, String methodName) {
                if (isBlock) {
                    if (isNullable) {
                        return NULLABLE_BLOCK_INPUT_CHANNEL;
                    }
                    return BLOCK_INPUT_CHANNEL;
                }
                if (isNullable) {
                    throw new IllegalArgumentException(methodName + " contains a parameter with @NullablePosition that is not @BlockPosition");
                }
                return INPUT_CHANNEL;
            }
        }
    }
}

