/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.WindowIndex;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class AccumulatorCompiler {
    private AccumulatorCompiler() {
    }

    public static GenericAccumulatorFactoryBinder generateAccumulatorFactoryBinder(AggregationMetadata metadata, DynamicClassLoader classLoader) {
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new GenericAccumulatorFactoryBinder(metadata.getStateSerializer(), metadata.getStateFactory(), accumulatorClass, groupedAccumulatorClass);
    }

    private static <T> Class<? extends T> generateAccumulatorClass(Class<T> accumulatorInterface, AggregationMetadata metadata, DynamicClassLoader classLoader) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(metadata.getName() + accumulatorInterface.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(accumulatorInterface)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        AccumulatorStateSerializer<?> stateSerializer = metadata.getStateSerializer();
        AccumulatorStateFactory<?> stateFactory = metadata.getStateFactory();
        FieldDefinition stateSerializerField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateSerializer", AccumulatorStateSerializer.class);
        FieldDefinition stateFactoryField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateFactory", AccumulatorStateFactory.class);
        FieldDefinition inputChannelsField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "inputChannels", ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        FieldDefinition maskChannelField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "maskChannel", ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        Class stateClass = grouped ? stateFactory.getGroupedStateClass() : stateFactory.getSingleStateClass();
        FieldDefinition stateField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "state", stateClass);
        AccumulatorCompiler.generateConstructor(definition, stateSerializerField, stateFactoryField, inputChannelsField, maskChannelField, stateField, grouped);
        AccumulatorCompiler.generateAddInput(definition, stateField, inputChannelsField, maskChannelField, metadata.getInputMetadata(), metadata.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateAddInputWindowIndex(definition, stateField, metadata.getInputMetadata(), metadata.getInputFunction(), callSiteBinder);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateField);
        AccumulatorCompiler.generateGetIntermediateType(definition, callSiteBinder, stateSerializer.getSerializedType());
        AccumulatorCompiler.generateGetFinalType(definition, callSiteBinder, metadata.getOutputType());
        AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateField, stateSerializerField, stateFactoryField, metadata.getCombineFunction(), stateClass, callSiteBinder, grouped);
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateSerializerField, stateField);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, stateSerializerField, stateField);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, stateField, metadata.getOutputFunction(), callSiteBinder);
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, stateField, metadata.getOutputFunction(), callSiteBinder);
        }
        if (grouped) {
            AccumulatorCompiler.generatePrepareFinal(definition);
        }
        return CompilerUtils.defineClass(definition, accumulatorInterface, callSiteBinder.getBindings(), (ClassLoader)classLoader);
    }

    private static MethodDefinition generateGetIntermediateType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getIntermediateType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static MethodDefinition generateGetFinalType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getFinalType", ParameterizedType.type(Type.class), new Parameter[0]);
        methodDefinition.getBody().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, FieldDefinition stateField) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        BytecodeExpression state = method.getThis().getField(stateField);
        method.getBody().append((BytecodeNode)state.invoke("getEstimatedSize", Long.TYPE, new BytecodeExpression[0]).ret());
    }

    private static void generateAddInput(ClassDefinition definition, FieldDefinition stateField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        Parameter page = Parameter.arg((String)"page", Page.class);
        parameters.add((Object)page);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addInput", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        ArrayList<Variable> parameterVariables = new ArrayList<Variable>();
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            parameterVariables.add(scope.declareVariable(Block.class, "block" + i));
        }
        Variable masksBlock = scope.declareVariable(Block.class, "masksBlock");
        body.comment("masksBlock = maskChannel.map(page.blockGetter()).orElse(null);").append((BytecodeNode)thisVariable.getField(maskChannelField)).append((BytecodeNode)page).invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, (Class[])new Class[]{Integer.class, Block.class}), new ParameterizedType[]{ParameterizedType.type(Page.class)}).invokeVirtual(Optional.class, "map", Optional.class, new Class[]{Function.class}).pushNull().invokeVirtual(Optional.class, "orElse", Object.class, new Class[]{Object.class}).checkCast(Block.class).putVariable(masksBlock);
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            body.comment("%s = page.getBlock(inputChannels.get(%d));", new Object[]{((Variable)parameterVariables.get(i)).getName(), i}).append((BytecodeNode)page).append((BytecodeNode)thisVariable.getField(inputChannelsField)).push(i).invokeInterface(List.class, "get", Object.class, new Class[]{Integer.TYPE}).checkCast(Integer.class).invokeVirtual(Integer.class, "intValue", Integer.TYPE, new Class[0]).invokeVirtual(Page.class, "getBlock", Block.class, new Class[]{Integer.TYPE}).putVariable((Variable)parameterVariables.get(i));
        }
        BytecodeBlock block = AccumulatorCompiler.generateInputForLoop(stateField, parameterMetadatas, inputFunction, scope, parameterVariables, masksBlock, callSiteBinder, grouped);
        body.append((BytecodeNode)block);
        body.ret();
    }

    private static void generateAddInputWindowIndex(ClassDefinition definition, FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder) {
        Parameter index = Parameter.arg((String)"index", WindowIndex.class);
        Parameter channels = Parameter.arg((String)"channels", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        Parameter startPosition = Parameter.arg((String)"startPosition", Integer.TYPE);
        Parameter endPosition = Parameter.arg((String)"endPosition", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addInput", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.of((Object)index, (Object)channels, (Object)startPosition, (Object)endPosition));
        Scope scope = method.getScope();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Binding binding = callSiteBinder.bind(inputFunction);
        BytecodeExpression invokeInputFunction = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)"input", (MethodType)binding.getType(), AccumulatorCompiler.getInvokeFunctionOnWindowIndexParameters(scope, inputFunction.type().parameterArray(), parameterMetadatas, stateField, (Variable)index, (Variable)channels, position));
        method.getBody().append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set((BytecodeExpression)startPosition)).condition((BytecodeNode)BytecodeExpressions.lessThanOrEqual((BytecodeExpression)position, (BytecodeExpression)endPosition)).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)AccumulatorCompiler.anyParametersAreNull(parameterMetadatas, (Variable)index, (Variable)channels, position)).ifFalse((BytecodeNode)invokeInputFunction))).ret();
    }

    private static BytecodeExpression anyParametersAreNull(List<AggregationMetadata.ParameterMetadata> parameterMetadatas, Variable index, Variable channels, Variable position) {
        int inputChannel = 0;
        BytecodeExpression isNull = BytecodeExpressions.constantFalse();
        for (AggregationMetadata.ParameterMetadata parameterMetadata : parameterMetadatas) {
            switch (parameterMetadata.getParameterType()) {
                case BLOCK_INPUT_CHANNEL: 
                case INPUT_CHANNEL: {
                    BytecodeExpression getChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)inputChannel)}).cast(Integer.TYPE);
                    isNull = BytecodeExpressions.or((BytecodeExpression)isNull, (BytecodeExpression)index.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{getChannel, position}));
                    ++inputChannel;
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    ++inputChannel;
                }
            }
        }
        return isNull;
    }

    private static List<BytecodeExpression> getInvokeFunctionOnWindowIndexParameters(Scope scope, Class<?>[] parameterTypes, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, FieldDefinition stateField, Variable index, Variable channels, Variable position) {
        int inputChannel = 0;
        ArrayList<BytecodeExpression> expressions = new ArrayList<BytecodeExpression>();
        block6: for (int i = 0; i < parameterTypes.length; ++i) {
            AggregationMetadata.ParameterMetadata parameterMetadata = parameterMetadatas.get(i);
            Class<?> parameterType = parameterTypes[i];
            BytecodeExpression getChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)inputChannel)}).cast(Integer.TYPE);
            switch (parameterMetadata.getParameterType()) {
                case STATE: {
                    expressions.add(scope.getThis().getField(stateField));
                    continue block6;
                }
                case BLOCK_INDEX: {
                    expressions.add(BytecodeExpressions.constantInt((int)0));
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    expressions.add(index.invoke("getSingleValueBlock", Block.class, new BytecodeExpression[]{getChannel, position}));
                    ++inputChannel;
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    if (parameterType == Long.TYPE) {
                        expressions.add(index.invoke("getLong", Long.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Double.TYPE) {
                        expressions.add(index.invoke("getDouble", Double.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Boolean.TYPE) {
                        expressions.add(index.invoke("getBoolean", Boolean.TYPE, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Slice.class) {
                        expressions.add(index.invoke("getSlice", Slice.class, new BytecodeExpression[]{getChannel, position}));
                    } else if (parameterType == Block.class) {
                        expressions.add(index.invoke("getObject", Object.class, new BytecodeExpression[]{getChannel, position}));
                    } else {
                        throw new IllegalArgumentException(String.format("Unsupported parameter type: %s", parameterType));
                    }
                    ++inputChannel;
                }
            }
        }
        return expressions;
    }

    private static BytecodeBlock generateInputForLoop(FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, Scope scope, List<Variable> parameterVariables, Variable masksBlock, CallSiteBinder callSiteBinder, boolean grouped) {
        Variable page = scope.getVariable("page");
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)page).invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable).initializeVariable(positionVariable);
        BytecodeBlock loopBody = AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, parameterVariables, parameterMetadatas, inputFunction, callSiteBinder, grouped);
        ArrayList<Boolean> nullable = new ArrayList<Boolean>();
        for (AggregationMetadata.ParameterMetadata metadata : parameterMetadatas) {
            switch (metadata.getParameterType()) {
                case BLOCK_INPUT_CHANNEL: 
                case INPUT_CHANNEL: {
                    nullable.add(false);
                    break;
                }
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    nullable.add(true);
                    break;
                }
            }
        }
        Preconditions.checkState((nullable.size() == parameterVariables.size() ? 1 : 0) != 0, (Object)"Number of parameters does not match");
        for (int i = 0; i < parameterVariables.size(); ++i) {
            if (((Boolean)nullable.get(i)).booleanValue()) continue;
            Variable variableDefinition = parameterVariables.get(i);
            loopBody = new IfStatement("if(!%s.isNull(position))", new Object[]{variableDefinition.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(variableDefinition).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        }
        loopBody = new IfStatement("if(testMask(%s, position))", new Object[]{masksBlock.getName()}).condition((BytecodeNode)new BytecodeBlock().getVariable(masksBlock).getVariable(positionVariable).invokeStatic(CompilerOperations.class, "testMask", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE})).ifTrue((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)new BytecodeBlock().putVariable(positionVariable, 0)).condition((BytecodeNode)new BytecodeBlock().getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)loopBody));
        return block;
    }

    private static BytecodeBlock generateInvokeInputFunction(Scope scope, FieldDefinition stateField, Variable position, List<Variable> parameterVariables, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        BytecodeBlock block = new BytecodeBlock();
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(scope, stateField, block);
        }
        block.comment("Call input function with unpacked Block arguments");
        Class<?>[] parameters = inputFunction.type().parameterArray();
        int inputChannel = 0;
        block6: for (int i = 0; i < parameters.length; ++i) {
            AggregationMetadata.ParameterMetadata parameterMetadata = parameterMetadatas.get(i);
            switch (parameterMetadata.getParameterType()) {
                case STATE: {
                    block.append((BytecodeNode)scope.getThis().getField(stateField));
                    continue block6;
                }
                case BLOCK_INDEX: {
                    block.getVariable(position);
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    block.getVariable(parameterVariables.get(inputChannel));
                    ++inputChannel;
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    BytecodeBlock getBlockBytecode = new BytecodeBlock().getVariable(parameterVariables.get(inputChannel));
                    AccumulatorCompiler.pushStackType(scope, block, parameterMetadata.getSqlType(), getBlockBytecode, parameters[i], callSiteBinder);
                    ++inputChannel;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + (Object)((Object)parameterMetadata.getParameterType()));
                }
            }
        }
        block.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputFunction), "input"));
        return block;
    }

    private static void pushStackType(Scope scope, BytecodeBlock block, Type sqlType, BytecodeBlock getBlockBytecode, Class<?> parameter, CallSiteBinder callSiteBinder) {
        Variable position = scope.getVariable("position");
        if (parameter == Long.TYPE) {
            block.comment("%s.getLong(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getLong", Long.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Double.TYPE) {
            block.comment("%s.getDouble(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getDouble", Double.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Boolean.TYPE) {
            block.comment("%s.getBoolean(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getBoolean", Boolean.TYPE, new Class[]{Block.class, Integer.TYPE});
        } else if (parameter == Slice.class) {
            block.comment("%s.getSlice(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getSlice", Slice.class, new Class[]{Block.class, Integer.TYPE});
        } else {
            block.comment("%s.getObject(block, position)", new Object[]{sqlType.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, sqlType)).append((BytecodeNode)getBlockBytecode).append((BytecodeNode)position).invokeInterface(Type.class, "getObject", Object.class, new Class[]{Block.class, Integer.TYPE});
        }
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, FieldDefinition stateField, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, MethodHandle combineFunction, Class<?> stateClass, CallSiteBinder callSiteBinder, boolean grouped) {
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        Variable block = scope.getVariable("block");
        Variable scratchState = scope.declareVariable(stateClass, "scratchState");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        String createStateMethodName = grouped ? "createGroupedState" : "createSingleState";
        body.comment(String.format("scratchState = stateFactory.%s()", createStateMethodName)).append((BytecodeNode)thisVariable.getField(stateFactoryField)).invokeInterface(AccumulatorStateFactory.class, createStateMethodName, Object.class, new Class[0]).checkCast(scratchState.getType()).putVariable(scratchState);
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(scope, stateField, body);
        }
        BytecodeBlock loopBody = new BytecodeBlock();
        if (grouped) {
            Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
            loopBody.append((BytecodeNode)thisVariable.getField(stateField).invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
        }
        loopBody.append((BytecodeNode)thisVariable.getField(stateSerializerField).invoke("deserialize", Void.TYPE, new BytecodeExpression[]{block, position, scratchState.cast(Object.class)}));
        loopBody.comment("combine(state, scratchState)").append((BytecodeNode)thisVariable.getField(stateField)).append((BytecodeNode)scratchState).append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(combineFunction), "combine"));
        if (grouped) {
            IfStatement ifStatement = new IfStatement("if (!groupIdsBlock.isNull(position))", new Object[0]).condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)scope.getVariable("groupIdsBlock").invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}))).ifTrue((BytecodeNode)loopBody);
            loopBody = new BytecodeBlock().append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, position, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIdsBlock(Scope scope, FieldDefinition stateField, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        Variable position = scope.getVariable("position");
        BytecodeExpression state = scope.getThis().getField(stateField);
        block.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupId", Long.TYPE, new BytecodeExpression[]{position})}));
    }

    private static void generateEnsureCapacity(Scope scope, FieldDefinition stateField, BytecodeBlock block) {
        Variable groupIdsBlock = scope.getVariable("groupIdsBlock");
        BytecodeExpression state = scope.getThis().getField(stateField);
        block.append((BytecodeNode)state.invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{groupIdsBlock.invoke("getGroupCount", Long.TYPE, new BytecodeExpression[0])}));
    }

    private static MethodDefinition declareAddIntermediate(ClassDefinition definition, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)Parameter.arg((String)"block", Block.class));
        return definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
    }

    private static BytecodeBlock generateBlockNonNullPositionForLoop(Scope scope, Variable positionVariable, BytecodeBlock loopBody) {
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable blockVariable = scope.getVariable("block");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)blockVariable).invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement ifStatement = new IfStatement("if(!block.isNull(position))", new Object[0]).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockVariable).append((BytecodeNode)positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positionVariable).append((BytecodeNode)rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)ifStatement));
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        BytecodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        method.getBody().append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)})).append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(Object.class), out})).ret();
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        Variable thisVariable = method.getThis();
        BytecodeExpression stateSerializer = thisVariable.getField(stateSerializerField);
        BytecodeExpression state = thisVariable.getField(stateField);
        method.getBody().append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(Object.class), out})).ret();
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, FieldDefinition stateField, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)}));
        body.comment("output(state, out)");
        body.append((BytecodeNode)state);
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, FieldDefinition stateField, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        BytecodeExpression state = thisVariable.getField(stateField);
        body.comment("output(state, out)");
        body.append((BytecodeNode)state);
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output"));
        body.ret();
    }

    private static void generatePrepareFinal(ClassDefinition definition) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "prepareFinal", ParameterizedType.type(Void.TYPE), new Parameter[0]);
        method.getBody().ret();
    }

    private static void generateConstructor(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, FieldDefinition stateField, boolean grouped) {
        Parameter stateSerializer = Parameter.arg((String)"stateSerializer", AccumulatorStateSerializer.class);
        Parameter stateFactory = Parameter.arg((String)"stateFactory", AccumulatorStateFactory.class);
        Parameter inputChannels = Parameter.arg((String)"inputChannels", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Integer.class}));
        Parameter maskChannel = Parameter.arg((String)"maskChannel", (ParameterizedType)ParameterizedType.type(Optional.class, (Class[])new Class[]{Integer.class}));
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{stateSerializer, stateFactory, inputChannels, maskChannel});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(stateSerializerField, AccumulatorCompiler.generateRequireNotNull((Variable)stateSerializer)));
        body.append((BytecodeNode)thisVariable.setField(stateFactoryField, AccumulatorCompiler.generateRequireNotNull((Variable)stateFactory)));
        body.append((BytecodeNode)thisVariable.setField(inputChannelsField, AccumulatorCompiler.generateRequireNotNull((Variable)inputChannels)));
        body.append((BytecodeNode)thisVariable.setField(maskChannelField, AccumulatorCompiler.generateRequireNotNull((Variable)maskChannel)));
        String createState = grouped ? "createGroupedState" : "createSingleState";
        body.append((BytecodeNode)thisVariable.setField(stateField, stateFactory.invoke(createState, Object.class, new BytecodeExpression[0]).cast(stateField.getType())));
        body.ret();
    }

    private static BytecodeExpression generateRequireNotNull(Variable variable) {
        return BytecodeExpressions.invokeStatic(Objects.class, (String)"requireNonNull", Object.class, (BytecodeExpression[])new BytecodeExpression[]{variable.cast(Object.class), BytecodeExpressions.constantString((String)(variable.getName() + " is null"))}).cast(variable.getType());
    }
}

