/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class TaskContext {
    private final QueryContext queryContext;
    private final TaskStateMachine taskStateMachine;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final Session session;
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final Set<Lifespan> completedDriverGroups = Sets.newConcurrentHashSet();
    private final List<PipelineContext> pipelineContexts = new CopyOnWriteArrayList<PipelineContext>();
    private final boolean verboseStats;
    private final boolean cpuTimerEnabled;
    private final Object cumulativeMemoryLock = new Object();
    private final AtomicDouble cumulativeMemory = new AtomicDouble(0.0);
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastMemoryReservation;
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastTaskStatCallNanos;
    private final MemoryTrackingContext taskMemoryContext;

    public static TaskContext createTaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, boolean verboseStats, boolean cpuTimerEnabled) {
        TaskContext taskContext = new TaskContext(queryContext, taskStateMachine, notificationExecutor, yieldExecutor, session, taskMemoryContext, verboseStats, cpuTimerEnabled);
        taskContext.initialize();
        return taskContext;
    }

    private TaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, boolean verboseStats, boolean cpuTimerEnabled) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.session = session;
        this.taskMemoryContext = Objects.requireNonNull(taskMemoryContext, "taskMemoryContext is null");
        this.verboseStats = verboseStats;
        this.cpuTimerEnabled = cpuTimerEnabled;
    }

    private void initialize() {
        this.taskStateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                this.executionEndTime.set(DateTime.now());
                this.endNanos.set(System.nanoTime());
            }
        });
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public PipelineContext addPipelineContext(int pipelineId, boolean inputPipeline, boolean outputPipeline) {
        PipelineContext pipelineContext = new PipelineContext(pipelineId, this, this.notificationExecutor, this.yieldExecutor, this.taskMemoryContext.newMemoryTrackingContext(), inputPipeline, outputPipeline);
        this.pipelineContexts.add(pipelineContext);
        return pipelineContext;
    }

    public Session getSession() {
        return this.session;
    }

    public void start() {
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.lastExecutionStartTime.set(now);
    }

    public void failed(Throwable cause) {
        this.taskStateMachine.failed(cause);
    }

    public boolean isDone() {
        return this.taskStateMachine.getState().isDone();
    }

    public TaskState getState() {
        return this.taskStateMachine.getState();
    }

    public DataSize getMemoryReservation() {
        return new DataSize((double)this.taskMemoryContext.getUserMemory(), DataSize.Unit.BYTE);
    }

    public DataSize getSystemMemoryReservation() {
        return new DataSize((double)this.taskMemoryContext.getSystemMemory(), DataSize.Unit.BYTE);
    }

    public Set<Lifespan> getCompletedDriverGroups() {
        return this.completedDriverGroups;
    }

    public void addCompletedDriverGroup(Lifespan driverGroup) {
        Preconditions.checkArgument((!driverGroup.isTaskWide() ? 1 : 0) != 0, (Object)"driverGroup is task-wide, not a driver group.");
        this.completedDriverGroups.add(driverGroup);
    }

    public List<PipelineContext> getPipelineContexts() {
        return this.pipelineContexts;
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        return this.queryContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.queryContext.freeSpill(bytes);
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return this.taskMemoryContext.localSystemMemoryContext();
    }

    public synchronized LocalMemoryContext createNewTransferredBytesMemoryContext() {
        return this.taskMemoryContext.newUserMemoryContext();
    }

    public void moreMemoryAvailable() {
        this.pipelineContexts.forEach(PipelineContext::moreMemoryAvailable);
    }

    public boolean isVerboseStats() {
        return this.verboseStats;
    }

    public boolean isCpuTimerEnabled() {
        return this.cpuTimerEnabled;
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputPositions());
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStats getTaskStats() {
        DateTime now;
        if (this.taskStateMachine.getState().isDone() && this.executionEndTime.compareAndSet(null, now = DateTime.now())) {
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.endNanos.set(System.nanoTime());
        }
        ImmutableList pipelineStats = ImmutableList.copyOf((Iterable)Iterables.transform(this.pipelineContexts, PipelineContext::getPipelineStats));
        long lastExecutionEndTime = 0L;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int queuedPartitionedDrivers = 0;
        int runningDrivers = 0;
        int runningPartitionedDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        for (PipelineStats pipeline2 : pipelineStats) {
            if (pipeline2.getLastEndTime() != null) {
                lastExecutionEndTime = Math.max(pipeline2.getLastEndTime().getMillis(), lastExecutionEndTime);
            }
            totalDrivers += pipeline2.getTotalDrivers();
            queuedDrivers += pipeline2.getQueuedDrivers();
            queuedPartitionedDrivers += pipeline2.getQueuedPartitionedDrivers();
            runningDrivers += pipeline2.getRunningDrivers();
            runningPartitionedDrivers += pipeline2.getRunningPartitionedDrivers();
            blockedDrivers += pipeline2.getBlockedDrivers();
            completedDrivers += pipeline2.getCompletedDrivers();
            totalScheduledTime += pipeline2.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += pipeline2.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += pipeline2.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += pipeline2.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (pipeline2.isInputPipeline()) {
                rawInputDataSize += pipeline2.getRawInputDataSize().toBytes();
                rawInputPositions += pipeline2.getRawInputPositions();
                processedInputDataSize += pipeline2.getProcessedInputDataSize().toBytes();
                processedInputPositions += pipeline2.getProcessedInputPositions();
            }
            if (pipeline2.isOutputPipeline()) {
                outputDataSize += pipeline2.getOutputDataSize().toBytes();
                outputPositions += pipeline2.getOutputPositions();
            }
            physicalWrittenDataSize += pipeline2.getPhysicalWrittenDataSize().toBytes();
        }
        long startNanos = this.startNanos.get();
        if (startNanos == 0L) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration(0.0, TimeUnit.NANOSECONDS);
        long userMemory = this.taskMemoryContext.getUserMemory();
        Object object = this.cumulativeMemoryLock;
        synchronized (object) {
            double sinceLastPeriodMillis = (double)(System.nanoTime() - this.lastTaskStatCallNanos) / 1000000.0;
            long averageMemoryForLastPeriod = (userMemory + this.lastMemoryReservation) / 2L;
            this.cumulativeMemory.addAndGet((double)averageMemoryForLastPeriod * sinceLastPeriodMillis);
            this.lastTaskStatCallNanos = System.nanoTime();
            this.lastMemoryReservation = userMemory;
        }
        Set runningPipelineStats = (Set)pipelineStats.stream().filter(pipeline -> pipeline.getRunningDrivers() > 0 || pipeline.getRunningPartitionedDrivers() > 0 || pipeline.getBlockedDrivers() > 0).collect(ImmutableSet.toImmutableSet());
        ImmutableSet blockedReasons = (ImmutableSet)runningPipelineStats.stream().flatMap(pipeline -> pipeline.getBlockedReasons().stream()).collect(ImmutableSet.toImmutableSet());
        boolean fullyBlocked = !runningPipelineStats.isEmpty() && runningPipelineStats.stream().allMatch(PipelineStats::isFullyBlocked);
        return new TaskStats(this.taskStateMachine.getCreatedTime(), this.executionStartTime.get(), this.lastExecutionStartTime.get(), lastExecutionEndTime == 0L ? null : new DateTime(lastExecutionEndTime), this.executionEndTime.get(), elapsedTime.convertToMostSuccinctTimeUnit(), queuedTime.convertToMostSuccinctTimeUnit(), totalDrivers, queuedDrivers, queuedPartitionedDrivers, runningDrivers, runningPartitionedDrivers, blockedDrivers, completedDrivers, this.cumulativeMemory.get(), DataSize.succinctBytes((long)userMemory), DataSize.succinctBytes((long)this.taskMemoryContext.getRevocableMemory()), DataSize.succinctBytes((long)this.taskMemoryContext.getSystemMemory()), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked && (runningDrivers > 0 || runningPartitionedDrivers > 0), (Set<BlockedReason>)blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), (List<PipelineStats>)pipelineStats);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitTaskContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.pipelineContexts.stream().map(pipelineContext -> pipelineContext.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public synchronized MemoryTrackingContext getTaskMemoryContext() {
        return this.taskMemoryContext;
    }
}

