/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ReferenceCount {
    private final SettableFuture<Void> freeFuture = SettableFuture.create();
    @GuardedBy(value="this")
    private int count = 1;

    public ReferenceCount(int initialCount) {
        Preconditions.checkArgument((initialCount >= 1 ? 1 : 0) != 0, (Object)"initialCount must be at least 1");
        this.count = initialCount;
    }

    public ListenableFuture<Void> getFreeFuture() {
        return this.freeFuture;
    }

    public synchronized void retain() {
        Preconditions.checkState((!this.freeFuture.isDone() ? 1 : 0) != 0, (Object)"Reference has already been freed");
        ++this.count;
    }

    public synchronized void release() {
        Preconditions.checkState((!this.freeFuture.isDone() ? 1 : 0) != 0, (Object)"Reference has already been freed");
        --this.count;
        if (this.count == 0) {
            this.freeFuture.set(null);
        }
    }
}

