/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MarkDistinctHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MarkDistinctOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final MarkDistinctHash markDistinctHash;
    private final LocalMemoryContext localUserMemoryContext;
    private Page inputPage;
    private boolean finishing;
    private Work<Block> unfinishedWork;

    public MarkDistinctOperator(OperatorContext operatorContext, List<Type> types, List<Integer> markDistinctChannels, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        Objects.requireNonNull(markDistinctChannels, "markDistinctChannels is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        this.markDistinctHash = new MarkDistinctHash(operatorContext.getSession(), (List<Type>)distinctTypes.build(), Ints.toArray(markDistinctChannels), hashChannel, joinCompiler, this::updateMemoryReservation);
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput());
        this.inputPage = page;
        this.unfinishedWork = this.markDistinctHash.markDistinctRows(page);
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork == null) {
            return null;
        }
        if (!this.unfinishedWork.process()) {
            return null;
        }
        Block[] sourceBlocks = this.inputPage.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = this.unfinishedWork.getResult();
        this.unfinishedWork = null;
        this.inputPage = null;
        this.updateMemoryReservation();
        return new Page(outputBlocks);
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.markDistinctHash.getEstimatedSize());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.markDistinctHash.getCapacity();
    }

    public static class MarkDistinctOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> hashChannel;
        private final List<Integer> markDistinctChannels;
        private final List<Type> types;
        private final JoinCompiler joinCompiler;
        private boolean closed;

        public MarkDistinctOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, Collection<Integer> markDistinctChannels, Optional<Integer> hashChannel, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.markDistinctChannels = ImmutableList.copyOf(Objects.requireNonNull(markDistinctChannels, "markDistinctChannels is null"));
            Preconditions.checkArgument((!markDistinctChannels.isEmpty() ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.types = ImmutableList.builder().addAll(sourceTypes).add((Object)BooleanType.BOOLEAN).build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MarkDistinctOperator.class.getSimpleName());
            return new MarkDistinctOperator(operatorContext, this.types, this.markDistinctChannels, this.hashChannel, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MarkDistinctOperatorFactory(this.operatorId, this.planNodeId, this.types.subList(0, this.types.size() - 1), this.markDistinctChannels, this.hashChannel, this.joinCompiler);
        }
    }
}

