/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.TransformWork;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        this(session, types, channels, hashChannel, 10000, joinCompiler, updateMemory);
    }

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, int expectedDistinctValues, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(types, channels, hashChannel, expectedDistinctValues, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Work<Block> markDistinctRows(Page page) {
        return new TransformWork<GroupByIdBlock, Block>(this.groupByHash.getGroupIds(page), ids -> {
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus(), ids.getPositionCount());
            for (int i = 0; i < ids.getPositionCount(); ++i) {
                if (ids.getGroupId(i) == this.nextDistinctId) {
                    BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
                    ++this.nextDistinctId;
                    continue;
                }
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
            }
            return blockBuilder.build();
        });
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }
}

