/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.operator.SharedLookupSourceFactory;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class LookupSourceFactoryManager {
    private final List<Type> outputTypes;
    private final InternalLookupSourceFactoryManager internalLookupSourceFactoryManager;

    public LookupSourceFactoryManager(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider, List<Type> outputTypes) {
        Objects.requireNonNull(probeExecutionStrategy, "probeExecutionStrategy is null");
        Objects.requireNonNull(lookupSourceExecutionStrategy, "lookupSourceExecutionStrategy is null");
        Objects.requireNonNull(lookupSourceFactoryProvider, "lookupSourceFactoryProvider is null");
        this.internalLookupSourceFactoryManager = LookupSourceFactoryManager.internalLookupSourceFactoryManager(probeExecutionStrategy, lookupSourceExecutionStrategy, lookupSourceFactoryProvider);
        this.outputTypes = Objects.requireNonNull(outputTypes, "outputTypes is null");
    }

    public static LookupSourceFactoryManager allAtOnce(PartitionedLookupSourceFactory factory) {
        return new LookupSourceFactoryManager(PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, ignored -> factory, factory.getOutputTypes());
    }

    public List<Type> getBuildOutputTypes() {
        return this.outputTypes;
    }

    public LookupSourceFactory forLifespan(Lifespan lifespan) {
        return this.internalLookupSourceFactoryManager.get(lifespan);
    }

    public void noMoreLookupSourceFactory() {
        this.internalLookupSourceFactoryManager.noMoreLookupSourceFactory();
    }

    private static InternalLookupSourceFactoryManager internalLookupSourceFactoryManager(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider) {
        switch (probeExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                switch (lookupSourceExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new TaskWideInternalLookupSourceFactoryManager(lookupSourceFactoryProvider);
                    }
                    case GROUPED_EXECUTION: {
                        throw new UnsupportedOperationException("Invalid combination. Lookup source should not be grouped if probe is not going to take advantage of it.");
                    }
                }
                throw new IllegalArgumentException("Unknown lookupSourceExecutionStrategy: " + (Object)((Object)lookupSourceExecutionStrategy));
            }
            case GROUPED_EXECUTION: {
                switch (lookupSourceExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new SharedInternalLookupSourceFactoryManager(lookupSourceFactoryProvider);
                    }
                    case GROUPED_EXECUTION: {
                        return new OneToOneInternalLookupSourceFactoryManager(lookupSourceFactoryProvider);
                    }
                }
                throw new IllegalArgumentException("Unknown lookupSourceExecutionStrategy: " + (Object)((Object)lookupSourceExecutionStrategy));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class SharedInternalLookupSourceFactoryManager
    implements InternalLookupSourceFactoryManager {
        private final LookupSourceFactory taskWideLookupSourceFactory;
        private final Map<Lifespan, LookupSourceFactory> map = new ConcurrentHashMap<Lifespan, LookupSourceFactory>();
        private final ReferenceCount referenceCount;

        public SharedInternalLookupSourceFactoryManager(Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider) {
            this.taskWideLookupSourceFactory = lookupSourceFactoryProvider.apply(Lifespan.taskWide());
            this.referenceCount = new ReferenceCount(1);
            this.referenceCount.getFreeFuture().addListener(this.taskWideLookupSourceFactory::destroy, MoreExecutors.directExecutor());
        }

        @Override
        public LookupSourceFactory get(Lifespan lifespan) {
            if (Lifespan.taskWide().equals(lifespan)) {
                return this.taskWideLookupSourceFactory;
            }
            return this.map.computeIfAbsent(lifespan, ignored -> {
                this.referenceCount.retain();
                return new SharedLookupSourceFactory(this.taskWideLookupSourceFactory, this.referenceCount::release);
            });
        }

        @Override
        public void noMoreLookupSourceFactory() {
            this.referenceCount.release();
        }
    }

    private static class OneToOneInternalLookupSourceFactoryManager
    implements InternalLookupSourceFactoryManager {
        private final Map<Lifespan, LookupSourceFactory> map = new ConcurrentHashMap<Lifespan, LookupSourceFactory>();
        private final Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider;

        public OneToOneInternalLookupSourceFactoryManager(Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider) {
            this.lookupSourceFactoryProvider = lookupSourceFactoryProvider;
        }

        @Override
        public LookupSourceFactory get(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            return this.map.computeIfAbsent(lifespan, this.lookupSourceFactoryProvider);
        }
    }

    private static class TaskWideInternalLookupSourceFactoryManager
    implements InternalLookupSourceFactoryManager {
        private final Supplier<LookupSourceFactory> supplier = Suppliers.memoize(() -> (LookupSourceFactory)lookupSourceFactoryProvider.apply(Lifespan.taskWide()));

        public TaskWideInternalLookupSourceFactoryManager(Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider) {
        }

        @Override
        public LookupSourceFactory get(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            return this.supplier.get();
        }
    }

    private static interface InternalLookupSourceFactoryManager {
        public LookupSourceFactory get(Lifespan var1);

        default public void noMoreLookupSourceFactory() {
        }
    }
}

