/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;

public class LookupJoinPageBuilder {
    private final IntArrayList probeIndexBuilder = new IntArrayList();
    private final PageBuilder buildPageBuilder;
    private final int buildOutputChannelCount;
    private int estimatedProbeBlockBytes;
    private boolean isSequentialProbeIndices = true;

    public LookupJoinPageBuilder(List<Type> buildTypes) {
        this.buildPageBuilder = new PageBuilder(Objects.requireNonNull(buildTypes, "buildTypes is null"));
        this.buildOutputChannelCount = buildTypes.size();
    }

    public boolean isFull() {
        return (long)this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes() >= 0x100000L || this.buildPageBuilder.isFull();
    }

    public boolean isEmpty() {
        return this.probeIndexBuilder.isEmpty() && this.buildPageBuilder.isEmpty();
    }

    public void reset() {
        this.probeIndexBuilder.clear();
        this.buildPageBuilder.reset();
        this.estimatedProbeBlockBytes = 0;
        this.isSequentialProbeIndices = true;
    }

    public void appendRow(JoinProbe probe, LookupSource lookupSource, long joinPosition) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        lookupSource.appendTo(joinPosition, this.buildPageBuilder, 0);
    }

    public void appendNullForBuild(JoinProbe probe) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        for (int i = 0; i < this.buildOutputChannelCount; ++i) {
            this.buildPageBuilder.getBlockBuilder(i).appendNull();
        }
    }

    public Page build(JoinProbe probe) {
        int[] probeIndices = this.probeIndexBuilder.toIntArray();
        int length = probeIndices.length;
        Verify.verify((this.buildPageBuilder.getPositionCount() == length ? 1 : 0) != 0);
        int[] probeOutputChannels = probe.getOutputChannels();
        Block[] blocks = new Block[probeOutputChannels.length + this.buildOutputChannelCount];
        for (int i = 0; i < probeOutputChannels.length; ++i) {
            Block probeBlock = probe.getPage().getBlock(probeOutputChannels[i]);
            if (!this.isSequentialProbeIndices || length == 0) {
                blocks[i] = probeBlock.getPositions(probeIndices, 0, probeIndices.length);
                continue;
            }
            if (length == probeBlock.getPositionCount()) {
                Verify.verify((probeIndices[0] == 0 ? 1 : 0) != 0);
                Verify.verify((probeIndices[length - 1] == length - 1 ? 1 : 0) != 0);
                blocks[i] = probeBlock;
                continue;
            }
            Verify.verify((probeIndices[length - 1] - probeIndices[0] == length - 1 ? 1 : 0) != 0);
            blocks[i] = probeBlock.getRegion(probeIndices[0], length);
        }
        Page buildPage = this.buildPageBuilder.build();
        int offset = probeOutputChannels.length;
        for (int i = 0; i < this.buildOutputChannelCount; ++i) {
            blocks[offset + i] = buildPage.getBlock(i);
        }
        return new Page(this.buildPageBuilder.getPositionCount(), blocks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("estimatedSize", (long)this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes()).add("positionCount", this.buildPageBuilder.getPositionCount()).toString();
    }

    private void appendProbeIndex(JoinProbe probe) {
        int position = probe.getPosition();
        Verify.verify((position >= 0 ? 1 : 0) != 0);
        int previousPosition = this.probeIndexBuilder.isEmpty() ? -1 : this.probeIndexBuilder.get(this.probeIndexBuilder.size() - 1);
        Verify.verify((previousPosition <= position ? 1 : 0) != 0);
        this.isSequentialProbeIndices &= position == previousPosition + 1 || previousPosition == -1;
        this.probeIndexBuilder.add(position);
        if (previousPosition == position) {
            return;
        }
        for (int index : probe.getOutputChannels()) {
            Block block = probe.getPage().getBlock(index);
            this.estimatedProbeBlockBytes = (int)((long)this.estimatedProbeBlockBytes + block.getSizeInBytes() / (long)block.getPositionCount());
        }
    }
}

