/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceFactoryManager;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> probeOutputTypes;
    private final List<Type> buildOutputTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Optional<OperatorFactory> outerOperatorFactory;
    private final PerLifespanDataManager perLifespanDataManager;
    private final OptionalInt totalOperatorsCount;
    private final HashGenerator probeHashGenerator;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, LookupSourceFactoryManager lookupSourceFactoryManager, List<Type> probeTypes, List<Type> probeOutputTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, JoinProbe.JoinProbeFactory joinProbeFactory, OptionalInt totalOperatorsCount, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.probeOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null"));
        this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.perLifespanDataManager = new PerLifespanDataManager(joinType, lookupSourceFactoryManager);
        this.outerOperatorFactory = joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER ? Optional.empty() : Optional.of(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, this.perLifespanDataManager::getOuterPositionsFuture, probeOutputTypes, buildOutputTypes, this.perLifespanDataManager::getLookupSourceFactoryUsersCount));
        this.totalOperatorsCount = Objects.requireNonNull(totalOperatorsCount, "totalOperatorsCount is null");
        Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
        if (probeHashChannel.isPresent()) {
            this.probeHashGenerator = new PrecomputedHashGenerator(probeHashChannel.getAsInt());
        } else {
            Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null");
            List hashTypes = (List)probeJoinChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
            this.probeHashGenerator = new InterpretedHashGenerator((List<Type>)hashTypes, probeJoinChannels);
        }
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.probeOutputTypes = other.probeOutputTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.joinProbeFactory = other.joinProbeFactory;
        this.perLifespanDataManager = other.perLifespanDataManager.duplicate();
        this.outerOperatorFactory = other.outerOperatorFactory;
        this.totalOperatorsCount = other.totalOperatorsCount;
        this.probeHashGenerator = other.probeHashGenerator;
        this.partitioningSpillerFactory = other.partitioningSpillerFactory;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.builder().addAll(this.probeOutputTypes).addAll(this.buildOutputTypes).build();
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.perLifespanDataManager.getLookupSourceFactory(driverContext.getLifespan());
        ReferenceCount probeReferenceCount = this.perLifespanDataManager.getProbeReferenceCount(driverContext.getLifespan());
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupJoinOperator.class.getSimpleName());
        lookupSourceFactory.setTaskContext(driverContext.getPipelineContext().getTaskContext());
        probeReferenceCount.retain();
        return new LookupJoinOperator(operatorContext, this.getTypes(), this.probeTypes, this.buildOutputTypes, this.joinType, lookupSourceFactory, this.joinProbeFactory, probeReferenceCount::release, this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory);
    }

    @Override
    public void noMoreOperators() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.perLifespanDataManager.noMoreLifespan();
    }

    @Override
    public void noMoreOperators(Lifespan lifespan) {
        this.perLifespanDataManager.getProbeReferenceCount(lifespan).release();
    }

    @Override
    public OperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    @Override
    public Optional<OperatorFactory> createOuterOperatorFactory() {
        return this.outerOperatorFactory;
    }

    public static class FreezeOnReadCounter {
        private int count;
        private boolean freezed;

        public synchronized void increment() {
            Preconditions.checkState((!this.freezed ? 1 : 0) != 0, (Object)"Counter has been read");
            ++this.count;
        }

        public synchronized int get() {
            this.freezed = true;
            return this.count;
        }
    }

    public static class PerLifespanData {
        private final LookupSourceFactory lookupSourceFactory;
        private final ReferenceCount probeReferenceCount;
        private final ReferenceCount lookupSourceFactoryUsersCount;
        private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;

        public PerLifespanData(LookupJoinOperators.JoinType joinType, int factoryCount, LookupSourceFactory lookupSourceFactory) {
            this.lookupSourceFactory = lookupSourceFactory;
            this.lookupSourceFactoryUsersCount = new ReferenceCount(1);
            this.lookupSourceFactoryUsersCount.getFreeFuture().addListener(lookupSourceFactory::destroy, MoreExecutors.directExecutor());
            this.probeReferenceCount = new ReferenceCount(factoryCount);
            this.probeReferenceCount.getFreeFuture().addListener(this.lookupSourceFactoryUsersCount::release, MoreExecutors.directExecutor());
            if (joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER) {
                this.outerPositionsFuture = null;
            } else {
                this.lookupSourceFactoryUsersCount.retain();
                ListenableFuture lookupSourceProviderAfterProbeFinished = Futures.transformAsync(this.probeReferenceCount.getFreeFuture(), ignored -> lookupSourceFactory.createLookupSourceProvider());
                this.outerPositionsFuture = Futures.transform((ListenableFuture)lookupSourceProviderAfterProbeFinished, lookupSourceProvider -> {
                    lookupSourceProvider.close();
                    return lookupSourceFactory.getOuterPositionIterator();
                });
            }
        }

        public LookupSourceFactory getLookupSourceFactory() {
            return this.lookupSourceFactory;
        }

        public ReferenceCount getProbeReferenceCount() {
            return this.probeReferenceCount;
        }

        public ReferenceCount getLookupSourceFactoryUsersCount() {
            return this.lookupSourceFactoryUsersCount;
        }

        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture() {
            return this.outerPositionsFuture;
        }
    }

    public static class PerLifespanDataManager {
        private final LookupJoinOperators.JoinType joinType;
        private final FreezeOnReadCounter factoryCount;
        private final LookupSourceFactoryManager lookupSourceFactoryManager;
        private final Map<Lifespan, PerLifespanData> dataByLifespan;
        private final ReferenceCount probeFactoryReferenceCount;
        private boolean closed;

        public PerLifespanDataManager(LookupJoinOperators.JoinType joinType, LookupSourceFactoryManager lookupSourceFactoryManager) {
            this.joinType = joinType;
            this.lookupSourceFactoryManager = lookupSourceFactoryManager;
            this.dataByLifespan = new ConcurrentHashMap<Lifespan, PerLifespanData>();
            this.factoryCount = new FreezeOnReadCounter();
            this.factoryCount.increment();
            this.probeFactoryReferenceCount = new ReferenceCount(1);
            this.probeFactoryReferenceCount.getFreeFuture().addListener(lookupSourceFactoryManager::noMoreLookupSourceFactory, MoreExecutors.directExecutor());
        }

        private PerLifespanDataManager(PerLifespanDataManager other) {
            this.joinType = other.joinType;
            this.factoryCount = other.factoryCount;
            this.lookupSourceFactoryManager = other.lookupSourceFactoryManager;
            this.dataByLifespan = other.dataByLifespan;
            this.probeFactoryReferenceCount = other.probeFactoryReferenceCount;
            this.factoryCount.increment();
            this.probeFactoryReferenceCount.retain();
        }

        public PerLifespanDataManager duplicate() {
            return new PerLifespanDataManager(this);
        }

        public void noMoreLifespan() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            this.probeFactoryReferenceCount.release();
        }

        public LookupSourceFactory getLookupSourceFactory(Lifespan lifespan) {
            return this.data(lifespan).getLookupSourceFactory();
        }

        public ReferenceCount getProbeReferenceCount(Lifespan lifespan) {
            return this.data(lifespan).getProbeReferenceCount();
        }

        public ReferenceCount getLookupSourceFactoryUsersCount(Lifespan lifespan) {
            return this.data(lifespan).getLookupSourceFactoryUsersCount();
        }

        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
            return this.data(lifespan).getOuterPositionsFuture();
        }

        private PerLifespanData data(Lifespan lifespan) {
            return this.dataByLifespan.computeIfAbsent(lifespan, id -> {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0);
                return new PerLifespanData(this.joinType, this.factoryCount.get(), this.lookupSourceFactoryManager.forLifespan((Lifespan)id));
            });
        }
    }
}

