/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.XxHash64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HashPartitionMaskOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int partition;
    private final int partitionCount;
    private final List<Type> types;
    private final int[] maskChannels;
    private final HashGenerator hashGenerator;
    private Page outputPage;
    private boolean finishing;

    public HashPartitionMaskOperator(OperatorContext operatorContext, int partition, int partitionCount, List<Type> types, List<Integer> maskChannels, List<Integer> partitionChannels, Optional<Integer> hashChannel) {
        this.partition = partition;
        this.partitionCount = partitionCount;
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.maskChannels = Ints.toArray((Collection)Objects.requireNonNull(maskChannels, "maskChannels is null"));
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        Objects.requireNonNull(partitionChannels, "partitionChannels is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : partitionChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        ImmutableList.Builder partitionChannelTypes = ImmutableList.builder();
        for (int channel : partitionChannels) {
            partitionChannelTypes.add((Object)types.get(channel));
        }
        this.hashGenerator = hashChannel.isPresent() ? new PrecomputedHashGenerator(hashChannel.get()) : new InterpretedHashGenerator((List<Type>)partitionChannelTypes.build(), Ints.toArray(partitionChannels));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        BlockBuilder activePositions = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus(), page.getPositionCount());
        BlockBuilder[] maskBuilders = new BlockBuilder[this.maskChannels.length];
        for (int i = 0; i < maskBuilders.length; ++i) {
            maskBuilders[i] = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus(), page.getPositionCount());
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long rawHash = this.hashGenerator.hashPosition(position, page);
            rawHash = XxHash64.hash((long)Long.reverse(rawHash));
            boolean active = (rawHash &= Long.MAX_VALUE) % (long)this.partitionCount == (long)this.partition;
            BooleanType.BOOLEAN.writeBoolean(activePositions, active);
            for (int i = 0; i < maskBuilders.length; ++i) {
                Block maskBlock = page.getBlock(this.maskChannels[i]);
                if (maskBlock.isNull(position)) {
                    maskBuilders[i].appendNull();
                    continue;
                }
                boolean maskValue = active && BooleanType.BOOLEAN.getBoolean(maskBlock, position);
                BooleanType.BOOLEAN.writeBoolean(maskBuilders[i], maskValue);
            }
        }
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = activePositions.build();
        for (int i = 0; i < maskBuilders.length; ++i) {
            outputBlocks[this.maskChannels[i]] = maskBuilders[i].build();
        }
        this.outputPage = new Page(outputBlocks);
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class HashPartitionMaskOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final int partitionCount;
        private final Optional<Integer> hashChannel;
        private final List<Integer> maskChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> types;
        private int partition;
        private boolean closed;

        public HashPartitionMaskOperatorFactory(int operatorId, PlanNodeId planNodeId, int partitionCount, List<? extends Type> sourceTypes, Collection<Integer> maskChannels, Collection<Integer> partitionChannels, Optional<Integer> hashChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((partitionCount > 1 ? 1 : 0) != 0, (Object)"partition count must be greater than 1");
            this.partitionCount = partitionCount;
            this.maskChannels = ImmutableList.copyOf(Objects.requireNonNull(maskChannels, "maskChannels is null"));
            this.partitionChannels = ImmutableList.copyOf(Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            Preconditions.checkArgument((!partitionChannels.isEmpty() ? 1 : 0) != 0, (Object)"partitionChannels is empty");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.types = ImmutableList.builder().addAll(sourceTypes).add((Object)BooleanType.BOOLEAN).build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        public int getDefaultMaskChannel() {
            return this.types.size() - 1;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            Preconditions.checkState((this.partition < this.partitionCount ? 1 : 0) != 0, (Object)"All operators already created");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MarkDistinctOperator.class.getSimpleName());
            return new HashPartitionMaskOperator(operatorContext, this.partition++, this.partitionCount, this.types, this.maskChannels, this.partitionChannels, this.hashChannel);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new HashPartitionMaskOperatorFactory(this.operatorId, this.planNodeId, this.partitionCount, this.types.subList(0, this.types.size() - 1), this.maskChannels, this.partitionChannels, this.hashChannel);
        }
    }
}

